/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import android.support.annotation.NonNull;
import com.twilio.video.VideoCapturer;
import com.twilio.video.VideoFrame;
import tvi.webrtc.VideoCapturer;

final class VideoCapturerListenerAdapter
implements VideoCapturer.Listener {
    private final VideoCapturer.CapturerObserver webRtcCapturerObserver;

    public VideoCapturerListenerAdapter(VideoCapturer.CapturerObserver webRtcCapturerObserver) {
        this.webRtcCapturerObserver = webRtcCapturerObserver;
    }

    @Override
    public void onCapturerStarted(boolean success) {
        this.webRtcCapturerObserver.onCapturerStarted(success);
    }

    @Override
    public void onFrameCaptured(@NonNull VideoFrame videoFrame) {
        if (videoFrame.webRtcVideoFrame != null) {
            this.webRtcCapturerObserver.onFrameCaptured(videoFrame.webRtcVideoFrame);
        } else {
            this.webRtcCapturerObserver.onByteBufferFrameCaptured(videoFrame.imageBuffer, videoFrame.dimensions.width, videoFrame.dimensions.height, videoFrame.orientation.getValue(), videoFrame.timestamp);
        }
    }
}

