/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import android.support.annotation.NonNull;
import com.twilio.video.AspectRatio;
import com.twilio.video.VideoDimensions;

public class VideoConstraints {
    public static final int FPS_10 = 10;
    public static final int FPS_15 = 15;
    public static final int FPS_20 = 20;
    public static final int FPS_24 = 24;
    public static final int FPS_30 = 30;
    private final VideoDimensions minVideoDimensions;
    private final VideoDimensions maxVideoDimensions;
    private final int minFps;
    private final int maxFps;
    private final AspectRatio aspectRatio;

    private VideoConstraints(@NonNull Builder builder) {
        this.minVideoDimensions = builder.minVideoDimensions;
        this.maxVideoDimensions = builder.maxVideoDimensions;
        this.minFps = builder.minFps;
        this.maxFps = builder.maxFps;
        this.aspectRatio = builder.aspectRatio;
    }

    @NonNull
    public VideoDimensions getMinVideoDimensions() {
        return this.minVideoDimensions;
    }

    @NonNull
    public VideoDimensions getMaxVideoDimensions() {
        return this.maxVideoDimensions;
    }

    public int getMinFps() {
        return this.minFps;
    }

    public int getMaxFps() {
        return this.maxFps;
    }

    @NonNull
    public AspectRatio getAspectRatio() {
        return this.aspectRatio;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VideoConstraints that = (VideoConstraints)o;
        return this.minFps == that.minFps && this.maxFps == that.maxFps && this.minVideoDimensions.equals(that.minVideoDimensions) && this.maxVideoDimensions.equals(that.maxVideoDimensions) && this.aspectRatio.equals(that.aspectRatio);
    }

    public int hashCode() {
        int result = this.minVideoDimensions.hashCode();
        result = 31 * result + this.maxVideoDimensions.hashCode();
        result = 31 * result + this.minFps;
        result = 31 * result + this.maxFps;
        result = 31 * result + this.aspectRatio.hashCode();
        return result;
    }

    public static class Builder {
        private VideoDimensions minVideoDimensions = new VideoDimensions(0, 0);
        private VideoDimensions maxVideoDimensions = new VideoDimensions(0, 0);
        private int minFps = 0;
        private int maxFps = 0;
        private AspectRatio aspectRatio = new AspectRatio(0, 0);

        @NonNull
        public Builder minVideoDimensions(@NonNull VideoDimensions minVideoDimensions) {
            this.minVideoDimensions = minVideoDimensions;
            return this;
        }

        @NonNull
        public Builder maxVideoDimensions(@NonNull VideoDimensions maxVideoDimensions) {
            this.maxVideoDimensions = maxVideoDimensions;
            return this;
        }

        @NonNull
        public Builder minFps(int minFps) {
            this.minFps = minFps;
            return this;
        }

        @NonNull
        public Builder maxFps(int maxFps) {
            this.maxFps = maxFps;
            return this;
        }

        @NonNull
        public Builder aspectRatio(@NonNull AspectRatio aspectRatio) {
            this.aspectRatio = aspectRatio;
            return this;
        }

        @NonNull
        public VideoConstraints build() {
            if (this.minVideoDimensions == null) {
                throw new NullPointerException("MinVideoDimensions must not be null");
            }
            if (this.maxVideoDimensions == null) {
                throw new NullPointerException("MaxVideoDimensions must not be null");
            }
            if (this.minFps > this.maxFps) {
                throw new IllegalStateException("MinFps " + this.minFps + " is greater than maxFps " + this.maxFps);
            }
            if (this.minFps < 0) {
                throw new IllegalStateException("MinFps is less than 0");
            }
            if (this.maxFps < 0) {
                throw new IllegalStateException("MaxFps is less than 0");
            }
            if (this.minVideoDimensions.width > this.maxVideoDimensions.width) {
                throw new IllegalStateException("Min video dimensions width " + this.minVideoDimensions.width + " is greater than max video dimensions width " + this.maxVideoDimensions.width);
            }
            if (this.minVideoDimensions.height > this.maxVideoDimensions.height) {
                throw new IllegalStateException("Min video dimensions height " + this.minVideoDimensions.height + " is greater than max video dimensions height " + this.maxVideoDimensions.height);
            }
            if (this.aspectRatio.numerator < 0) {
                throw new IllegalStateException("aspectRatio numerator is less than 0");
            }
            if (this.aspectRatio.denominator < 0) {
                throw new IllegalStateException("aspectRatio denominator is less than 0");
            }
            return new VideoConstraints(this);
        }
    }
}

