/*
 * Decompiled with CFR 0.152.
 */
package tvi.webrtc;

import javax.annotation.Nullable;
import tvi.webrtc.AudioTrack;
import tvi.webrtc.CalledByNative;
import tvi.webrtc.JNINamespace;
import tvi.webrtc.JniCommon;
import tvi.webrtc.VideoTrack;

@JNINamespace(value="webrtc::jni")
public class MediaStreamTrack {
    public static final String AUDIO_TRACK_KIND = "audio";
    public static final String VIDEO_TRACK_KIND = "video";
    final long nativeTrack;

    @Nullable
    static MediaStreamTrack createMediaStreamTrack(long nativeTrack) {
        if (nativeTrack == 0L) {
            return null;
        }
        String trackKind = MediaStreamTrack.nativeGetKind(nativeTrack);
        if (trackKind.equals(AUDIO_TRACK_KIND)) {
            return new AudioTrack(nativeTrack);
        }
        if (trackKind.equals(VIDEO_TRACK_KIND)) {
            return new VideoTrack(nativeTrack);
        }
        return null;
    }

    public MediaStreamTrack(long nativeTrack) {
        this.nativeTrack = nativeTrack;
    }

    public String id() {
        return MediaStreamTrack.nativeGetId(this.nativeTrack);
    }

    public String kind() {
        return MediaStreamTrack.nativeGetKind(this.nativeTrack);
    }

    public boolean enabled() {
        return MediaStreamTrack.nativeGetEnabled(this.nativeTrack);
    }

    public boolean setEnabled(boolean enable) {
        return MediaStreamTrack.nativeSetEnabled(this.nativeTrack, enable);
    }

    public State state() {
        return MediaStreamTrack.nativeGetState(this.nativeTrack);
    }

    public void dispose() {
        JniCommon.nativeReleaseRef(this.nativeTrack);
    }

    private static native String nativeGetId(long var0);

    private static native String nativeGetKind(long var0);

    private static native boolean nativeGetEnabled(long var0);

    private static native boolean nativeSetEnabled(long var0, boolean var2);

    private static native State nativeGetState(long var0);

    public static enum MediaType {
        MEDIA_TYPE_AUDIO(0),
        MEDIA_TYPE_VIDEO(1);

        private final int nativeIndex;

        private MediaType(int nativeIndex) {
            this.nativeIndex = nativeIndex;
        }

        @CalledByNative(value="MediaType")
        int getNative() {
            return this.nativeIndex;
        }

        @CalledByNative(value="MediaType")
        static MediaType fromNativeIndex(int nativeIndex) {
            for (MediaType type : MediaType.values()) {
                if (type.getNative() != nativeIndex) continue;
                return type;
            }
            throw new IllegalArgumentException("Unknown native media type: " + nativeIndex);
        }
    }

    public static enum State {
        LIVE,
        ENDED;


        @CalledByNative(value="State")
        static State fromNativeIndex(int nativeIndex) {
            return State.values()[nativeIndex];
        }
    }
}

