/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import android.support.annotation.NonNull;
import com.twilio.video.LocalVideoTrack;
import com.twilio.video.Preconditions;
import com.twilio.video.VideoTrack;
import com.twilio.video.VideoTrackPublication;

public class LocalVideoTrackPublication
implements VideoTrackPublication {
    private final String sid;
    private final LocalVideoTrack localVideoTrack;

    LocalVideoTrackPublication(@NonNull String sid, @NonNull LocalVideoTrack localVideoTrack) {
        Preconditions.checkNotNull(sid, "SID must not be null");
        Preconditions.checkArgument(!sid.isEmpty(), "SID must not be empty");
        Preconditions.checkNotNull(localVideoTrack, "Local video track must not be null");
        this.sid = sid;
        this.localVideoTrack = localVideoTrack;
    }

    @Override
    @NonNull
    public String getTrackSid() {
        return this.sid;
    }

    @Override
    @NonNull
    public String getTrackName() {
        return this.localVideoTrack.getName();
    }

    @Override
    public boolean isTrackEnabled() {
        return this.localVideoTrack.isEnabled();
    }

    @Override
    @NonNull
    public VideoTrack getVideoTrack() {
        return this.localVideoTrack;
    }

    @NonNull
    public LocalVideoTrack getLocalVideoTrack() {
        return this.localVideoTrack;
    }
}

