/*
 * Decompiled with CFR 0.152.
 */
package tvi.webrtc;

import java.util.Arrays;
import java.util.LinkedHashSet;
import javax.annotation.Nullable;
import tvi.webrtc.EglBase;
import tvi.webrtc.HardwareVideoEncoderFactory;
import tvi.webrtc.SoftwareVideoEncoderFactory;
import tvi.webrtc.VideoCodecInfo;
import tvi.webrtc.VideoEncoder;
import tvi.webrtc.VideoEncoderFactory;

public class DefaultVideoEncoderFactory
implements VideoEncoderFactory {
    private final VideoEncoderFactory hardwareVideoEncoderFactory;
    private final VideoEncoderFactory softwareVideoEncoderFactory;

    public DefaultVideoEncoderFactory(EglBase.Context eglContext, boolean enableIntelVp8Encoder, boolean enableH264HighProfile) {
        this.hardwareVideoEncoderFactory = new HardwareVideoEncoderFactory(eglContext, enableIntelVp8Encoder, enableH264HighProfile, false);
        this.softwareVideoEncoderFactory = new SoftwareVideoEncoderFactory();
    }

    DefaultVideoEncoderFactory(VideoEncoderFactory hardwareVideoEncoderFactory) {
        this.hardwareVideoEncoderFactory = hardwareVideoEncoderFactory;
        this.softwareVideoEncoderFactory = new SoftwareVideoEncoderFactory();
    }

    @Override
    @Nullable
    public VideoEncoder createEncoder(VideoCodecInfo info) {
        VideoEncoder videoEncoder = this.hardwareVideoEncoderFactory.createEncoder(info);
        if (videoEncoder != null) {
            return videoEncoder;
        }
        return this.softwareVideoEncoderFactory.createEncoder(info);
    }

    @Override
    public VideoCodecInfo[] getSupportedCodecs() {
        LinkedHashSet<VideoCodecInfo> supportedCodecInfos = new LinkedHashSet<VideoCodecInfo>();
        supportedCodecInfos.addAll(Arrays.asList(this.softwareVideoEncoderFactory.getSupportedCodecs()));
        supportedCodecInfos.addAll(Arrays.asList(this.hardwareVideoEncoderFactory.getSupportedCodecs()));
        return supportedCodecInfos.toArray(new VideoCodecInfo[supportedCodecInfos.size()]);
    }
}

