/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.webrtc.CalledByNative;
import org.webrtc.NativeClassQualifiedName;
import org.webrtc.VideoEncoder;

class VideoEncoderWrapper {
    VideoEncoderWrapper() {
    }

    @CalledByNative
    static boolean getScalingSettingsOn(VideoEncoder.ScalingSettings scalingSettings) {
        return scalingSettings.on;
    }

    @Nullable
    @CalledByNative
    static Integer getScalingSettingsLow(VideoEncoder.ScalingSettings scalingSettings) {
        return scalingSettings.low;
    }

    @Nullable
    @CalledByNative
    static Integer getScalingSettingsHigh(VideoEncoder.ScalingSettings scalingSettings) {
        return scalingSettings.high;
    }

    @CalledByNative
    static VideoEncoder.Callback createEncoderCallback(long nativeEncoder) {
        return (frame, info) -> VideoEncoderWrapper.nativeOnEncodedFrame(nativeEncoder, frame.buffer, frame.encodedWidth, frame.encodedHeight, frame.captureTimeNs, frame.frameType.getNative(), frame.rotation, frame.completeFrame, frame.qp);
    }

    @NativeClassQualifiedName(value="webrtc::jni::VideoEncoderWrapper")
    private static native void nativeOnEncodedFrame(long var0, ByteBuffer var2, int var3, int var4, long var5, int var7, int var8, boolean var9, Integer var10);
}

