/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Pair;
import com.twilio.video.ConnectOptions;
import com.twilio.video.LocalParticipant;
import com.twilio.video.Logger;
import com.twilio.video.MediaFactory;
import com.twilio.video.Preconditions;
import com.twilio.video.RemoteParticipant;
import com.twilio.video.RoomState;
import com.twilio.video.StatsListener;
import com.twilio.video.StatsReport;
import com.twilio.video.ThreadChecker;
import com.twilio.video.TwilioException;
import com.twilio.video.Util;
import com.twilio.video.Video;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class Room {
    private static final Logger logger = Logger.getLogger(Room.class);
    private long nativeRoomDelegate;
    private Context context;
    private String name;
    private String sid;
    private RoomState roomState;
    private Map<String, RemoteParticipant> participantMap = new HashMap<String, RemoteParticipant>();
    private LocalParticipant localParticipant;
    private final Listener listener;
    private final Handler handler;
    private Queue<Pair<Handler, StatsListener>> statsListenersQueue;
    private MediaFactory mediaFactory;
    private final Listener roomListenerProxy = new Listener(){

        @Override
        public void onConnected(Room room) {
            Room.this.handler.post(() -> {
                ThreadChecker.checkIsValidThread(Room.this.handler);
                logger.d("onConnected()");
                Room.this.listener.onConnected(room);
            });
        }

        @Override
        public void onConnectFailure(Room room, TwilioException twilioException) {
            Room.this.releaseRoom();
            Room.this.handler.post(() -> {
                ThreadChecker.checkIsValidThread(Room.this.handler);
                logger.d("onConnectFailure()");
                Room.this.roomState = RoomState.DISCONNECTED;
                Room.this.release();
                Room.this.listener.onConnectFailure(room, twilioException);
            });
        }

        @Override
        public void onDisconnected(Room room, TwilioException twilioException) {
            Room.this.releaseRoom();
            if (Room.this.localParticipant != null) {
                Room.this.localParticipant.release();
            }
            Room.this.handler.post(() -> {
                ThreadChecker.checkIsValidThread(Room.this.handler);
                logger.d("onDisconnected()");
                Room.this.roomState = RoomState.DISCONNECTED;
                Room.this.release();
                Room.this.listener.onDisconnected(room, twilioException);
            });
        }

        @Override
        public void onParticipantConnected(Room room, RemoteParticipant participant) {
            Room.this.handler.post(() -> {
                ThreadChecker.checkIsValidThread(Room.this.handler);
                logger.d("onParticipantConnected()");
                Room.this.participantMap.put(participant.getSid(), participant);
                Room.this.listener.onParticipantConnected(room, participant);
            });
        }

        @Override
        public void onParticipantDisconnected(Room room, RemoteParticipant remoteParticipant) {
            remoteParticipant.release();
            Room.this.handler.post(() -> {
                ThreadChecker.checkIsValidThread(Room.this.handler);
                logger.d("onParticipantDisconnected()");
                Room.this.participantMap.remove(remoteParticipant.getSid());
                Room.this.listener.onParticipantDisconnected(room, remoteParticipant);
            });
        }

        @Override
        public void onRecordingStarted(Room room) {
            Room.this.handler.post(() -> {
                ThreadChecker.checkIsValidThread(Room.this.handler);
                logger.d("onRecordingStarted()");
                Room.this.listener.onRecordingStarted(room);
            });
        }

        @Override
        public void onRecordingStopped(Room room) {
            Room.this.handler.post(() -> {
                ThreadChecker.checkIsValidThread(Room.this.handler);
                logger.d("onRecordingStopped()");
                Room.this.listener.onRecordingStopped(room);
            });
        }
    };
    private final StatsListener statsListenerProxy = statsReports -> {
        Pair<Handler, StatsListener> statsPair = this.statsListenersQueue.poll();
        if (statsPair != null) {
            ((Handler)statsPair.first).post(() -> ((StatsListener)statsPair.second).onStats(statsReports));
        }
    };

    Room(Context context, String name, Handler handler, Listener listener) {
        this.context = context;
        this.name = name;
        this.sid = "";
        this.roomState = RoomState.DISCONNECTED;
        this.listener = listener;
        this.handler = handler;
        this.statsListenersQueue = new ConcurrentLinkedQueue<Pair<Handler, StatsListener>>();
    }

    public String getName() {
        return this.name;
    }

    public String getSid() {
        return this.sid;
    }

    public synchronized RoomState getState() {
        return this.roomState;
    }

    public synchronized boolean isRecording() {
        return this.roomState == RoomState.CONNECTED && this.nativeIsRecording(this.nativeRoomDelegate);
    }

    @NonNull
    public synchronized List<RemoteParticipant> getRemoteParticipants() {
        return new ArrayList<RemoteParticipant>(this.participantMap.values());
    }

    @Nullable
    public synchronized LocalParticipant getLocalParticipant() {
        return this.localParticipant;
    }

    @Nullable
    public synchronized void getStats(@NonNull StatsListener statsListener) {
        Preconditions.checkNotNull(statsListener, "StatsListener must not be null");
        if (this.roomState == RoomState.DISCONNECTED) {
            return;
        }
        this.statsListenersQueue.offer((Pair<Handler, StatsListener>)new Pair((Object)Util.createCallbackHandler(), (Object)statsListener));
        this.nativeGetStats(this.nativeRoomDelegate);
    }

    public synchronized void disconnect() {
        if (this.roomState != RoomState.DISCONNECTED && this.nativeRoomDelegate != 0L) {
            if (this.localParticipant != null) {
                this.localParticipant.release();
            }
            this.nativeDisconnect(this.nativeRoomDelegate);
        }
    }

    void onNetworkChanged(Video.NetworkChangeEvent networkChangeEvent) {
        if (this.nativeRoomDelegate != 0L) {
            this.nativeOnNetworkChange(this.nativeRoomDelegate, networkChangeEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"RestrictedApi"})
    void connect(ConnectOptions connectOptions) {
        ConnectOptions.checkAudioTracksReleased(connectOptions.getAudioTracks());
        ConnectOptions.checkVideoTracksReleased(connectOptions.getVideoTracks());
        Listener listener = this.roomListenerProxy;
        synchronized (listener) {
            this.mediaFactory = connectOptions.getMediaFactory() == null ? MediaFactory.instance(this, this.context) : connectOptions.getMediaFactory();
            this.nativeRoomDelegate = this.nativeConnect(connectOptions, this.roomListenerProxy, this.statsListenerProxy, this.mediaFactory.getNativeMediaFactoryHandle(), this.handler);
            this.roomState = RoomState.CONNECTING;
        }
    }

    private synchronized void setConnected(String roomSid, LocalParticipant localParticipant, List<RemoteParticipant> remoteParticipants) {
        logger.d("setConnected()");
        this.sid = roomSid;
        if (this.name == null || this.name.isEmpty()) {
            this.name = roomSid;
        }
        this.localParticipant = localParticipant;
        for (RemoteParticipant remoteParticipant : remoteParticipants) {
            this.participantMap.put(remoteParticipant.getSid(), remoteParticipant);
        }
        this.roomState = RoomState.CONNECTED;
    }

    private synchronized void releaseRoom() {
        if (this.nativeRoomDelegate != 0L) {
            for (RemoteParticipant remoteParticipant : this.participantMap.values()) {
                remoteParticipant.release();
            }
            this.nativeReleaseRoom(this.nativeRoomDelegate);
            this.cleanupStatsListenerQueue();
        }
    }

    private synchronized void release() {
        ThreadChecker.checkIsValidThread(this.handler);
        if (this.nativeRoomDelegate != 0L) {
            this.nativeRelease(this.nativeRoomDelegate);
            this.nativeRoomDelegate = 0L;
            this.mediaFactory.release(this);
        }
    }

    private void cleanupStatsListenerQueue() {
        for (Pair pair : this.statsListenersQueue) {
            ((Handler)pair.first).post(() -> ((StatsListener)listenerPair.second).onStats(new ArrayList<StatsReport>()));
        }
        this.statsListenersQueue.clear();
    }

    private native long nativeConnect(ConnectOptions var1, Listener var2, StatsListener var3, long var4, Handler var6);

    private native boolean nativeIsRecording(long var1);

    private native void nativeGetStats(long var1);

    private native void nativeOnNetworkChange(long var1, Video.NetworkChangeEvent var3);

    private native void nativeDisconnect(long var1);

    private native void nativeReleaseRoom(long var1);

    private native void nativeRelease(long var1);

    public static interface Listener {
        public void onConnected(Room var1);

        public void onConnectFailure(Room var1, TwilioException var2);

        public void onDisconnected(Room var1, TwilioException var2);

        public void onParticipantConnected(Room var1, RemoteParticipant var2);

        public void onParticipantDisconnected(Room var1, RemoteParticipant var2);

        public void onRecordingStarted(Room var1);

        public void onRecordingStopped(Room var1);
    }
}

