/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.opengl.GLES20;
import java.nio.FloatBuffer;
import java.util.IdentityHashMap;
import java.util.Map;
import org.webrtc.GlShader;
import org.webrtc.GlUtil;
import org.webrtc.RendererCommon;

public class GlRectDrawer
implements RendererCommon.GlDrawer {
    private static final String VERTEX_SHADER_STRING = "varying vec2 interp_tc;\nattribute vec4 in_pos;\nattribute vec4 in_tc;\n\nuniform mat4 texMatrix;\n\nvoid main() {\n    gl_Position = in_pos;\n    interp_tc = (texMatrix * in_tc).xy;\n}\n";
    private static final String YUV_FRAGMENT_SHADER_STRING = "precision mediump float;\nvarying vec2 interp_tc;\n\nuniform sampler2D y_tex;\nuniform sampler2D u_tex;\nuniform sampler2D v_tex;\n\nvoid main() {\n  float y = texture2D(y_tex, interp_tc).r;\n  float u = texture2D(u_tex, interp_tc).r - 0.5;\n  float v = texture2D(v_tex, interp_tc).r - 0.5;\n  gl_FragColor = vec4(y + 1.403 * v,                       y - 0.344 * u - 0.714 * v,                       y + 1.77 * u, 1);\n}\n";
    private static final String RGB_FRAGMENT_SHADER_STRING = "precision mediump float;\nvarying vec2 interp_tc;\n\nuniform sampler2D rgb_tex;\n\nvoid main() {\n  gl_FragColor = texture2D(rgb_tex, interp_tc);\n}\n";
    private static final String OES_FRAGMENT_SHADER_STRING = "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nvarying vec2 interp_tc;\n\nuniform samplerExternalOES oes_tex;\n\nvoid main() {\n  gl_FragColor = texture2D(oes_tex, interp_tc);\n}\n";
    private static final FloatBuffer FULL_RECTANGLE_BUF = GlUtil.createFloatBuffer(new float[]{-1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f});
    private static final FloatBuffer FULL_RECTANGLE_TEX_BUF = GlUtil.createFloatBuffer(new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f});
    private final Map<String, Shader> shaders = new IdentityHashMap<String, Shader>();

    @Override
    public void drawOes(int oesTextureId, float[] texMatrix, int frameWidth, int frameHeight, int viewportX, int viewportY, int viewportWidth, int viewportHeight) {
        this.prepareShader(OES_FRAGMENT_SHADER_STRING, texMatrix);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)36197, (int)oesTextureId);
        this.drawRectangle(viewportX, viewportY, viewportWidth, viewportHeight);
        GLES20.glBindTexture((int)36197, (int)0);
    }

    @Override
    public void drawRgb(int textureId, float[] texMatrix, int frameWidth, int frameHeight, int viewportX, int viewportY, int viewportWidth, int viewportHeight) {
        this.prepareShader(RGB_FRAGMENT_SHADER_STRING, texMatrix);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)textureId);
        this.drawRectangle(viewportX, viewportY, viewportWidth, viewportHeight);
        GLES20.glBindTexture((int)3553, (int)0);
    }

    @Override
    public void drawYuv(int[] yuvTextures, float[] texMatrix, int frameWidth, int frameHeight, int viewportX, int viewportY, int viewportWidth, int viewportHeight) {
        int i;
        this.prepareShader(YUV_FRAGMENT_SHADER_STRING, texMatrix);
        for (i = 0; i < 3; ++i) {
            GLES20.glActiveTexture((int)(33984 + i));
            GLES20.glBindTexture((int)3553, (int)yuvTextures[i]);
        }
        this.drawRectangle(viewportX, viewportY, viewportWidth, viewportHeight);
        for (i = 0; i < 3; ++i) {
            GLES20.glActiveTexture((int)(33984 + i));
            GLES20.glBindTexture((int)3553, (int)0);
        }
    }

    private void drawRectangle(int x, int y, int width, int height) {
        GLES20.glViewport((int)x, (int)y, (int)width, (int)height);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
    }

    private void prepareShader(String fragmentShader, float[] texMatrix) {
        Shader shader;
        if (this.shaders.containsKey(fragmentShader)) {
            shader = this.shaders.get(fragmentShader);
        } else {
            shader = new Shader(fragmentShader);
            this.shaders.put(fragmentShader, shader);
            shader.glShader.useProgram();
            if (fragmentShader == YUV_FRAGMENT_SHADER_STRING) {
                GLES20.glUniform1i((int)shader.glShader.getUniformLocation("y_tex"), (int)0);
                GLES20.glUniform1i((int)shader.glShader.getUniformLocation("u_tex"), (int)1);
                GLES20.glUniform1i((int)shader.glShader.getUniformLocation("v_tex"), (int)2);
            } else if (fragmentShader == RGB_FRAGMENT_SHADER_STRING) {
                GLES20.glUniform1i((int)shader.glShader.getUniformLocation("rgb_tex"), (int)0);
            } else if (fragmentShader == OES_FRAGMENT_SHADER_STRING) {
                GLES20.glUniform1i((int)shader.glShader.getUniformLocation("oes_tex"), (int)0);
            } else {
                throw new IllegalStateException("Unknown fragment shader: " + fragmentShader);
            }
            GlUtil.checkNoGLES2Error("Initialize fragment shader uniform values.");
            shader.glShader.setVertexAttribArray("in_pos", 2, FULL_RECTANGLE_BUF);
            shader.glShader.setVertexAttribArray("in_tc", 2, FULL_RECTANGLE_TEX_BUF);
        }
        shader.glShader.useProgram();
        GLES20.glUniformMatrix4fv((int)shader.texMatrixLocation, (int)1, (boolean)false, (float[])texMatrix, (int)0);
    }

    @Override
    public void release() {
        for (Shader shader : this.shaders.values()) {
            shader.glShader.release();
        }
        this.shaders.clear();
    }

    private static class Shader {
        public final GlShader glShader;
        public final int texMatrixLocation;

        public Shader(String fragmentShader) {
            this.glShader = new GlShader(GlRectDrawer.VERTEX_SHADER_STRING, fragmentShader);
            this.texMatrixLocation = this.glShader.getUniformLocation("texMatrix");
        }
    }
}

