/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.content.Context;
import android.os.SystemClock;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import org.webrtc.Logging;
import org.webrtc.SurfaceTextureHelper;
import org.webrtc.VideoCapturer;

public class FileVideoCapturer
implements VideoCapturer {
    private static final String TAG = "FileVideoCapturer";
    private final VideoReader videoReader;
    private VideoCapturer.CapturerObserver capturerObserver;
    private final Timer timer = new Timer();
    private final TimerTask tickTask = new TimerTask(){

        @Override
        public void run() {
            FileVideoCapturer.this.tick();
        }
    };

    private int getFrameWidth() {
        return this.videoReader.getFrameWidth();
    }

    private int getFrameHeight() {
        return this.videoReader.getFrameHeight();
    }

    public FileVideoCapturer(String inputFile) throws IOException {
        try {
            this.videoReader = new VideoReaderY4M(inputFile);
        }
        catch (IOException e) {
            Logging.d(TAG, "Could not open video file: " + inputFile);
            throw e;
        }
    }

    private byte[] getNextFrame() {
        return this.videoReader.getNextFrame();
    }

    public void tick() {
        long captureTimeNs = TimeUnit.MILLISECONDS.toNanos(SystemClock.elapsedRealtime());
        byte[] frameData = this.getNextFrame();
        this.capturerObserver.onByteBufferFrameCaptured(frameData, this.getFrameWidth(), this.getFrameHeight(), 0, captureTimeNs);
    }

    @Override
    public void initialize(SurfaceTextureHelper surfaceTextureHelper, Context applicationContext, VideoCapturer.CapturerObserver capturerObserver) {
        this.capturerObserver = capturerObserver;
    }

    @Override
    public void startCapture(int width, int height, int framerate) {
        this.timer.schedule(this.tickTask, 0L, (long)(1000 / framerate));
    }

    @Override
    public void stopCapture() throws InterruptedException {
        this.timer.cancel();
    }

    @Override
    public void changeCaptureFormat(int width, int height, int framerate) {
    }

    @Override
    public void dispose() {
        this.videoReader.close();
    }

    @Override
    public boolean isScreencast() {
        return false;
    }

    public static native void nativeI420ToNV21(byte[] var0, int var1, int var2, byte[] var3);

    private static class VideoReaderY4M
    implements VideoReader {
        private static final String TAG = "VideoReaderY4M";
        private final int frameWidth;
        private final int frameHeight;
        private final int frameSize;
        private final long videoStart;
        private static final String Y4M_FRAME_DELIMETER = "FRAME";
        private final RandomAccessFile mediaFileStream;

        @Override
        public int getFrameWidth() {
            return this.frameWidth;
        }

        @Override
        public int getFrameHeight() {
            return this.frameHeight;
        }

        public VideoReaderY4M(String file) throws IOException {
            this.mediaFileStream = new RandomAccessFile(file, "r");
            StringBuilder builder = new StringBuilder();
            while (true) {
                int c;
                if ((c = this.mediaFileStream.read()) == -1) {
                    throw new RuntimeException("Found end of file before end of header for file: " + file);
                }
                if (c == 10) break;
                builder.append((char)c);
            }
            this.videoStart = this.mediaFileStream.getFilePointer();
            String header = builder.toString();
            String[] headerTokens = header.split("[ ]");
            int w = 0;
            int h = 0;
            String colorSpace = "";
            block6: for (String tok : headerTokens) {
                char c = tok.charAt(0);
                switch (c) {
                    case 'W': {
                        w = Integer.parseInt(tok.substring(1));
                        continue block6;
                    }
                    case 'H': {
                        h = Integer.parseInt(tok.substring(1));
                        continue block6;
                    }
                    case 'C': {
                        colorSpace = tok.substring(1);
                    }
                }
            }
            Logging.d(TAG, "Color space: " + colorSpace);
            if (!colorSpace.equals("420") && !colorSpace.equals("420mpeg2")) {
                throw new IllegalArgumentException("Does not support any other color space than I420 or I420mpeg2");
            }
            if (w % 2 == 1 || h % 2 == 1) {
                throw new IllegalArgumentException("Does not support odd width or height");
            }
            this.frameWidth = w;
            this.frameHeight = h;
            this.frameSize = w * h * 3 / 2;
            Logging.d(TAG, "frame dim: (" + w + ", " + h + ") frameSize: " + this.frameSize);
        }

        @Override
        public byte[] getNextFrame() {
            byte[] frame = new byte[this.frameSize];
            try {
                String frameDelimStr;
                byte[] frameDelim = new byte[Y4M_FRAME_DELIMETER.length() + 1];
                if (this.mediaFileStream.read(frameDelim) < frameDelim.length) {
                    this.mediaFileStream.seek(this.videoStart);
                    if (this.mediaFileStream.read(frameDelim) < frameDelim.length) {
                        throw new RuntimeException("Error looping video");
                    }
                }
                if (!(frameDelimStr = new String(frameDelim)).equals("FRAME\n")) {
                    throw new RuntimeException("Frames should be delimited by FRAME plus newline, found delimter was: '" + frameDelimStr + "'");
                }
                this.mediaFileStream.readFully(frame);
                byte[] nv21Frame = new byte[this.frameSize];
                FileVideoCapturer.nativeI420ToNV21(frame, this.frameWidth, this.frameHeight, nv21Frame);
                return nv21Frame;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void close() {
            try {
                this.mediaFileStream.close();
            }
            catch (IOException e) {
                Logging.e(TAG, "Problem closing file", e);
            }
        }
    }

    private static interface VideoReader {
        public int getFrameWidth();

        public int getFrameHeight();

        public byte[] getNextFrame();

        public void close();
    }
}

