/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.twilio.video.AspectRatio;
import com.twilio.video.Logger;
import com.twilio.video.MediaFactory;
import com.twilio.video.Preconditions;
import com.twilio.video.VideoCapturer;
import com.twilio.video.VideoConstraints;
import com.twilio.video.VideoDimensions;
import com.twilio.video.VideoFormat;
import com.twilio.video.VideoTrack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class LocalVideoTrack
extends VideoTrack {
    private static final Logger logger = Logger.getLogger(LocalVideoTrack.class);
    private static final double ASPECT_RATIO_TOLERANCE = 0.05;
    private static final String CAPTURER_MUST_HAVE_ONE_SUPPORTED_FORMAT = "A VideoCapturer must provide at least one supported VideoFormat";
    static final VideoConstraints defaultVideoConstraints = new VideoConstraints.Builder().maxFps(30).maxVideoDimensions(VideoDimensions.VGA_VIDEO_DIMENSIONS).build();
    private long nativeLocalVideoTrackHandle;
    private final VideoCapturer videoCapturer;
    private final VideoConstraints videoConstraints;
    private final MediaFactory mediaFactory;

    public static LocalVideoTrack create(@NonNull Context context, boolean enabled, @NonNull VideoCapturer videoCapturer) {
        return LocalVideoTrack.create(context, enabled, videoCapturer, null);
    }

    public static LocalVideoTrack create(@NonNull Context context, boolean enabled, @NonNull VideoCapturer videoCapturer, @Nullable VideoConstraints videoConstraints) {
        Preconditions.checkNotNull(context, "Context must not be null");
        Preconditions.checkNotNull(videoCapturer, "VideoCapturer must not be null");
        Preconditions.checkState(videoCapturer.getSupportedFormats() != null && !videoCapturer.getSupportedFormats().isEmpty(), CAPTURER_MUST_HAVE_ONE_SUPPORTED_FORMAT);
        LocalVideoTrack localVideoTrack = MediaFactory.instance(context).createVideoTrack(enabled, videoCapturer, LocalVideoTrack.resolveConstraints(videoCapturer, videoConstraints));
        if (localVideoTrack == null) {
            logger.e("Failed to create local video track");
        }
        return localVideoTrack;
    }

    public VideoCapturer getVideoCapturer() {
        return this.videoCapturer;
    }

    public VideoConstraints getVideoConstraints() {
        return this.videoConstraints;
    }

    @Override
    public synchronized boolean isEnabled() {
        if (!this.isReleased()) {
            return this.nativeIsEnabled(this.nativeLocalVideoTrackHandle);
        }
        logger.e("Local video track is not enabled because it has been removed");
        return false;
    }

    public synchronized void enable(boolean enabled) {
        if (!this.isReleased()) {
            this.nativeEnable(this.nativeLocalVideoTrackHandle, enabled);
        } else {
            logger.e("Cannot enable a local video track that has been removed");
        }
    }

    @Override
    public synchronized void release() {
        if (!this.isReleased()) {
            super.release();
            this.nativeRelease(this.nativeLocalVideoTrackHandle);
            this.nativeLocalVideoTrackHandle = 0L;
            this.mediaFactory.release();
        }
    }

    LocalVideoTrack(long nativeLocalVideoTrackHandle, boolean enabled, VideoCapturer videoCapturer, VideoConstraints videoConstraints, org.webrtc.VideoTrack webrtcVideoTrack, MediaFactory mediaFactory) {
        super(webrtcVideoTrack, enabled);
        this.nativeLocalVideoTrackHandle = nativeLocalVideoTrackHandle;
        this.videoCapturer = videoCapturer;
        this.videoConstraints = videoConstraints;
        this.mediaFactory = mediaFactory;
    }

    private static VideoConstraints resolveConstraints(VideoCapturer videoCapturer, VideoConstraints videoConstraints) {
        if (videoConstraints == null || !LocalVideoTrack.constraintsCompatible(videoCapturer, videoConstraints)) {
            logger.e("Applying VideoConstraints closest to 640x480@30 FPS.");
            return LocalVideoTrack.getClosestCompatibleVideoConstraints(videoCapturer, defaultVideoConstraints);
        }
        return videoConstraints;
    }

    @VisibleForTesting(otherwise=2)
    static boolean constraintsCompatible(VideoCapturer videoCapturer, VideoConstraints videoConstraints) {
        for (VideoFormat videoFormat : videoCapturer.getSupportedFormats()) {
            boolean formatCompatible;
            VideoDimensions minVideoDimensions = videoConstraints.getMinVideoDimensions();
            VideoDimensions maxVideoDimensions = videoConstraints.getMaxVideoDimensions();
            AspectRatio aspectRatio = videoConstraints.getAspectRatio();
            int minFps = videoConstraints.getMinFps();
            int maxFps = videoConstraints.getMaxFps();
            boolean bl = formatCompatible = minVideoDimensions.width <= videoFormat.dimensions.width && minVideoDimensions.height <= videoFormat.dimensions.height && minFps <= videoFormat.framerate;
            if (maxVideoDimensions.width > 0) {
                formatCompatible &= maxVideoDimensions.width >= videoFormat.dimensions.width;
            }
            if (maxVideoDimensions.height > 0) {
                formatCompatible &= maxVideoDimensions.height >= videoFormat.dimensions.height;
            }
            if (maxFps > 0) {
                formatCompatible &= maxFps <= videoFormat.framerate;
            }
            if (aspectRatio.numerator > 0 && aspectRatio.denominator > 0) {
                double ratio = (double)videoFormat.dimensions.width / (double)videoFormat.dimensions.height;
                double targetRatio = (double)aspectRatio.numerator / (double)aspectRatio.denominator;
                formatCompatible &= Math.abs(ratio - targetRatio) < 0.05;
            }
            if (!formatCompatible) continue;
            logger.i("VideoConstraints are compatible with VideoCapturer");
            return true;
        }
        logger.e("VideoConstraints are not compatible with VideoCapturer");
        return false;
    }

    private static VideoConstraints getClosestCompatibleVideoConstraints(VideoCapturer videoCapturer, final VideoConstraints videoConstraints) {
        List<VideoFormat> supportedFormats = videoCapturer.getSupportedFormats();
        VideoDimensions closestSupportedVideoDimensions = Collections.min(supportedFormats, new ClosestComparator<VideoFormat>(){

            @Override
            int diff(VideoFormat videoFormat) {
                return Math.abs(videoConstraints.getMaxVideoDimensions().width - videoFormat.dimensions.width) + Math.abs(videoConstraints.getMaxVideoDimensions().height - videoFormat.dimensions.height);
            }
        }).dimensions;
        ArrayList<Integer> supportedFramerates = new ArrayList<Integer>();
        for (VideoFormat videoFormat : supportedFormats) {
            if (!videoFormat.dimensions.equals(closestSupportedVideoDimensions)) continue;
            supportedFramerates.add(videoFormat.framerate);
        }
        int closestSupportedFramerate = Collections.min(supportedFramerates, new ClosestComparator<Integer>(){

            @Override
            int diff(Integer framerate) {
                return Math.abs(videoConstraints.getMaxFps() - framerate);
            }
        });
        return new VideoConstraints.Builder().maxFps(closestSupportedFramerate).maxVideoDimensions(closestSupportedVideoDimensions).build();
    }

    boolean isReleased() {
        return this.nativeLocalVideoTrackHandle == 0L;
    }

    long getNativeHandle() {
        return this.nativeLocalVideoTrackHandle;
    }

    private native boolean nativeIsEnabled(long var1);

    private native void nativeEnable(long var1, boolean var3);

    private native void nativeRelease(long var1);

    private static abstract class ClosestComparator<T>
    implements Comparator<T> {
        private ClosestComparator() {
        }

        abstract int diff(T var1);

        @Override
        public int compare(T t1, T t2) {
            return this.diff(t1) - this.diff(t2);
        }
    }
}

