/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import android.os.Handler;
import com.twilio.video.AudioTrack;
import com.twilio.video.Logger;
import com.twilio.video.VideoTrack;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class Participant {
    private static final Logger logger = Logger.getLogger(Participant.class);
    private final String identity;
    private final String sid;
    private final List<AudioTrack> audioTracks;
    private final List<VideoTrack> videoTracks;
    private final Handler handler;
    private final AtomicReference<Listener> listenerReference = new AtomicReference<Object>(null);
    private final Listener participantListenerProxy = new Listener(){

        @Override
        public void onAudioTrackAdded(final Participant participant, final AudioTrack audioTrack) {
            logger.d("onAudioTrackAdded");
            if (audioTrack == null) {
                logger.w("Received audio track added callback for non-existing audio track");
                return;
            }
            Participant.this.audioTracks.add(audioTrack);
            final Listener listener = (Listener)Participant.this.listenerReference.get();
            if (listener != null) {
                Participant.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        listener.onAudioTrackAdded(participant, audioTrack);
                    }
                });
            }
        }

        @Override
        public void onAudioTrackRemoved(final Participant participant, final AudioTrack audioTrack) {
            logger.d("onAudioTrackRemoved");
            Participant.this.audioTracks.remove(audioTrack);
            if (audioTrack == null) {
                logger.w("Received audio track removed callback for non-existent audio track");
                return;
            }
            final Listener listener = (Listener)Participant.this.listenerReference.get();
            if (listener != null) {
                Participant.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        listener.onAudioTrackRemoved(participant, audioTrack);
                    }
                });
            }
        }

        @Override
        public void onVideoTrackAdded(final Participant participant, final VideoTrack videoTrack) {
            logger.d("onVideoTrackAdded");
            if (videoTrack == null) {
                logger.w("Received video track added callback for non-existing video track");
                return;
            }
            Participant.this.videoTracks.add(videoTrack);
            final Listener listener = (Listener)Participant.this.listenerReference.get();
            if (listener != null) {
                Participant.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        listener.onVideoTrackAdded(participant, videoTrack);
                    }
                });
            }
        }

        @Override
        public void onVideoTrackRemoved(final Participant participant, final VideoTrack videoTrack) {
            logger.d("onVideoTrackRemoved");
            Participant.this.videoTracks.remove(videoTrack);
            if (videoTrack == null) {
                logger.w("Received video track removed callback for non-existent video track");
                return;
            }
            videoTrack.release();
            final Listener listener = (Listener)Participant.this.listenerReference.get();
            if (listener != null) {
                Participant.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        listener.onVideoTrackRemoved(participant, videoTrack);
                    }
                });
            }
        }

        @Override
        public void onAudioTrackEnabled(final Participant participant, final AudioTrack audioTrack) {
            logger.d("onAudioTrackEnabled");
            if (audioTrack == null) {
                logger.w("Received audio track enabled callback for non-existent audio track");
                return;
            }
            audioTrack.setEnabled(true);
            final Listener listener = (Listener)Participant.this.listenerReference.get();
            if (listener != null) {
                Participant.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        listener.onAudioTrackEnabled(participant, audioTrack);
                    }
                });
            }
        }

        @Override
        public void onAudioTrackDisabled(final Participant participant, final AudioTrack audioTrack) {
            logger.d("onAudioTrackDisabled");
            if (audioTrack == null) {
                logger.w("Received audio track disabled callback for non-existent audio track");
                return;
            }
            audioTrack.setEnabled(false);
            final Listener listener = (Listener)Participant.this.listenerReference.get();
            if (listener != null) {
                Participant.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        listener.onAudioTrackDisabled(participant, audioTrack);
                    }
                });
            }
        }

        @Override
        public void onVideoTrackEnabled(final Participant participant, final VideoTrack videoTrack) {
            logger.d("onVideoTrackEnabled");
            if (videoTrack == null) {
                logger.w("Received video track enabled callback for non-existent video track");
                return;
            }
            videoTrack.setEnabled(true);
            final Listener listener = (Listener)Participant.this.listenerReference.get();
            if (listener != null) {
                Participant.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        listener.onVideoTrackEnabled(participant, videoTrack);
                    }
                });
            }
        }

        @Override
        public void onVideoTrackDisabled(final Participant participant, final VideoTrack videoTrack) {
            logger.d("onVideoTrackDisabled");
            if (videoTrack == null) {
                logger.w("Received video track disabled callback for non-existent video track");
                return;
            }
            videoTrack.setEnabled(false);
            final Listener listener = (Listener)Participant.this.listenerReference.get();
            if (listener != null) {
                Participant.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        listener.onVideoTrackDisabled(participant, videoTrack);
                    }
                });
            }
        }
    };
    private long nativeParticipantContext;

    Participant(String identity, String sid, List<AudioTrack> audioTracks, List<VideoTrack> videoTracks, Handler handler, long nativeParticipantContext) {
        this.identity = identity;
        this.sid = sid;
        this.audioTracks = audioTracks;
        this.videoTracks = videoTracks;
        this.handler = handler;
        this.nativeParticipantContext = nativeParticipantContext;
        this.nativeCreateParticipantListenerProxy(this.participantListenerProxy, nativeParticipantContext);
    }

    public String getIdentity() {
        return this.identity;
    }

    public String getSid() {
        return this.sid;
    }

    public List<AudioTrack> getAudioTracks() {
        return this.audioTracks;
    }

    public List<VideoTrack> getVideoTracks() {
        return this.videoTracks;
    }

    public void setListener(Listener listener) {
        this.listenerReference.set(listener);
    }

    public synchronized boolean isConnected() {
        if (!this.isReleased()) {
            return this.nativeIsConnected(this.nativeParticipantContext);
        }
        return false;
    }

    synchronized void release() {
        if (!this.isReleased()) {
            this.audioTracks.clear();
            for (VideoTrack videoTrack : this.videoTracks) {
                videoTrack.release();
            }
            this.videoTracks.clear();
            this.nativeRelease(this.nativeParticipantContext);
            this.nativeParticipantContext = 0L;
        }
    }

    boolean isReleased() {
        return this.nativeParticipantContext == 0L;
    }

    private native void nativeCreateParticipantListenerProxy(Listener var1, long var2);

    private native boolean nativeIsConnected(long var1);

    private native void nativeRelease(long var1);

    public static interface Listener {
        public void onAudioTrackAdded(Participant var1, AudioTrack var2);

        public void onAudioTrackRemoved(Participant var1, AudioTrack var2);

        public void onVideoTrackAdded(Participant var1, VideoTrack var2);

        public void onVideoTrackRemoved(Participant var1, VideoTrack var2);

        public void onAudioTrackEnabled(Participant var1, AudioTrack var2);

        public void onAudioTrackDisabled(Participant var1, AudioTrack var2);

        public void onVideoTrackEnabled(Participant var1, VideoTrack var2);

        public void onVideoTrackDisabled(Participant var1, VideoTrack var2);
    }
}

