/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import android.os.Handler;
import com.twilio.video.LocalMedia;
import com.twilio.video.LocalParticipant;
import com.twilio.video.Logger;
import com.twilio.video.NativeHandle;
import com.twilio.video.Participant;
import com.twilio.video.RoomState;
import com.twilio.video.VideoException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Room {
    private static final Logger logger = Logger.getLogger(Room.class);
    private long nativeRoomContext;
    private String name;
    private final LocalMedia localMedia;
    private String sid;
    private RoomState roomState;
    private Map<String, Participant> participantMap = new HashMap<String, Participant>();
    private InternalRoomListenerHandle internalRoomListenerHandle;
    private InternalRoomListenerImpl internalRoomListenerImpl;
    private LocalParticipant localParticipant;
    private final Listener listener;
    private final Handler handler;

    Room(String name, LocalMedia localMedia, Listener listener, Handler handler) {
        this.name = name;
        this.localMedia = localMedia;
        this.sid = "";
        this.roomState = RoomState.DISCONNECTED;
        this.listener = listener;
        this.internalRoomListenerImpl = new InternalRoomListenerImpl();
        this.internalRoomListenerHandle = new InternalRoomListenerHandle(this.internalRoomListenerImpl);
        this.handler = handler;
    }

    public String getName() {
        return this.name;
    }

    public String getSid() {
        return this.sid;
    }

    public RoomState getState() {
        return this.roomState;
    }

    public Map<String, Participant> getParticipants() {
        return new HashMap<String, Participant>(this.participantMap);
    }

    public LocalParticipant getLocalParticipant() {
        return this.localParticipant;
    }

    public synchronized void disconnect() {
        if (this.roomState != RoomState.DISCONNECTED && this.nativeRoomContext != 0L) {
            this.nativeDisconnect(this.nativeRoomContext);
        }
    }

    long getListenerNativeHandle() {
        return this.internalRoomListenerHandle.get();
    }

    void setNativeContext(long nativeRoomHandle) {
        this.nativeRoomContext = nativeRoomHandle;
    }

    Object getConnectLock() {
        return this.internalRoomListenerImpl;
    }

    synchronized void release() {
        if (this.nativeRoomContext != 0L) {
            this.nativeRelease(this.nativeRoomContext);
            this.nativeRoomContext = 0L;
            for (Participant participant : this.participantMap.values()) {
                participant.release();
            }
            this.internalRoomListenerHandle.release();
        }
    }

    void setState(RoomState roomState) {
        this.roomState = roomState;
    }

    private native void nativeDisconnect(long var1);

    private native void nativeRelease(long var1);

    class InternalRoomListenerHandle
    extends NativeHandle {
        public InternalRoomListenerHandle(InternalRoomListener listener) {
            super(listener);
        }

        @Override
        protected native long nativeCreate(Object var1);

        @Override
        protected native void nativeRelease(long var1);
    }

    public static interface Listener {
        public void onConnected(Room var1);

        public void onConnectFailure(Room var1, VideoException var2);

        public void onDisconnected(Room var1, VideoException var2);

        public void onParticipantConnected(Room var1, Participant var2);

        public void onParticipantDisconnected(Room var1, Participant var2);
    }

    class InternalRoomListenerImpl
    implements InternalRoomListener {
        InternalRoomListenerImpl() {
        }

        Handler getHandler() {
            return Room.this.handler;
        }

        @Override
        public synchronized void onConnected(String roomSid, String localParticipantSid, String localParticipantIdentity, List<Participant> participantList) {
            logger.d("onConnected()");
            Room.this.sid = roomSid;
            if (Room.this.name == null || Room.this.name.isEmpty()) {
                Room.this.name = roomSid;
            }
            Room.this.localParticipant = new LocalParticipant(localParticipantSid, localParticipantIdentity, Room.this.localMedia);
            for (Participant participant : participantList) {
                Room.this.participantMap.put(participant.getSid(), participant);
            }
            Room.this.roomState = RoomState.CONNECTED;
            Room.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    Room.this.listener.onConnected(Room.this);
                }
            });
        }

        @Override
        public synchronized void onDisconnected(final int errorCode) {
            logger.d("onDisconnected()");
            Room.this.roomState = RoomState.DISCONNECTED;
            Room.this.release();
            Room.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    Room.this.listener.onDisconnected(Room.this, new VideoException(errorCode, ""));
                }
            });
        }

        @Override
        public synchronized void onConnectFailure(final int errorCode) {
            logger.d("onConnectFailure()");
            Room.this.roomState = RoomState.DISCONNECTED;
            Room.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    Room.this.listener.onConnectFailure(Room.this, new VideoException(errorCode, ""));
                }
            });
        }

        @Override
        public synchronized void onParticipantConnected(final Participant participant) {
            logger.d("onParticipantConnected()");
            Room.this.participantMap.put(participant.getSid(), participant);
            Room.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    Room.this.listener.onParticipantConnected(Room.this, participant);
                }
            });
        }

        @Override
        public synchronized void onParticipantDisconnected(String participantSid) {
            logger.d("onParticipantDisconnected()");
            final Participant participant = (Participant)Room.this.participantMap.remove(participantSid);
            if (participant == null) {
                logger.w("Received participant disconnected callback for non-existent participant");
                return;
            }
            participant.release();
            Room.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    Room.this.listener.onParticipantDisconnected(Room.this, participant);
                }
            });
        }
    }

    static interface InternalRoomListener {
        public void onConnected(String var1, String var2, String var3, List<Participant> var4);

        public void onDisconnected(int var1);

        public void onConnectFailure(int var1);

        public void onParticipantConnected(Participant var1);

        public void onParticipantDisconnected(String var1);
    }
}

