/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import com.twilio.video.Media;

public class Participant {
    private final String identity;
    private final String sid;
    private final Media media;
    private long nativeParticipantContext;

    Participant(String identity, String sid, Media media, long nativeParticipantContext) {
        this.identity = identity;
        this.sid = sid;
        this.media = media;
        this.nativeParticipantContext = nativeParticipantContext;
    }

    public String getIdentity() {
        return this.identity;
    }

    public Media getMedia() {
        return this.media;
    }

    public String getSid() {
        return this.sid;
    }

    public synchronized boolean isConnected() {
        if (!this.isReleased()) {
            return this.nativeIsConnected(this.nativeParticipantContext);
        }
        return false;
    }

    synchronized void release() {
        if (!this.isReleased()) {
            if (this.media != null) {
                this.media.release();
            }
            this.nativeRelease(this.nativeParticipantContext);
            this.nativeParticipantContext = 0L;
        }
    }

    boolean isReleased() {
        return this.nativeParticipantContext == 0L;
    }

    private native boolean nativeIsConnected(long var1);

    private native void nativeRelease(long var1);
}

