/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.graphics.ImageFormat;
import android.hardware.Camera;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.webrtc.Camera1Enumerator;
import org.webrtc.Logging;
import org.webrtc.Size;

public class CameraEnumerationAndroid {
    private static final String TAG = "CameraEnumerationAndroid";

    @Deprecated
    public static String[] getDeviceNames() {
        return new Camera1Enumerator().getDeviceNames();
    }

    @Deprecated
    public static int getDeviceCount() {
        return new Camera1Enumerator().getDeviceNames().length;
    }

    @Deprecated
    public static String getDeviceName(int index) {
        new Camera1Enumerator();
        return Camera1Enumerator.getDeviceName(index);
    }

    @Deprecated
    public static String getNameOfFrontFacingDevice() {
        return CameraEnumerationAndroid.getNameOfDevice(1);
    }

    @Deprecated
    public static String getNameOfBackFacingDevice() {
        return CameraEnumerationAndroid.getNameOfDevice(0);
    }

    public static CaptureFormat.FramerateRange getClosestSupportedFramerateRange(List<CaptureFormat.FramerateRange> supportedFramerates, final int requestedFps) {
        return Collections.min(supportedFramerates, new ClosestComparator<CaptureFormat.FramerateRange>(){
            private static final int MAX_FPS_DIFF_THRESHOLD = 5000;
            private static final int MAX_FPS_LOW_DIFF_WEIGHT = 1;
            private static final int MAX_FPS_HIGH_DIFF_WEIGHT = 3;
            private static final int MIN_FPS_THRESHOLD = 8000;
            private static final int MIN_FPS_LOW_VALUE_WEIGHT = 1;
            private static final int MIN_FPS_HIGH_VALUE_WEIGHT = 4;

            private int progressivePenalty(int value, int threshold, int lowWeight, int highWeight) {
                return value < threshold ? value * lowWeight : threshold * lowWeight + (value - threshold) * highWeight;
            }

            @Override
            int diff(CaptureFormat.FramerateRange range) {
                int minFpsError = this.progressivePenalty(range.min, 8000, 1, 4);
                int maxFpsError = this.progressivePenalty(Math.abs(requestedFps * 1000 - range.max), 5000, 1, 3);
                return minFpsError + maxFpsError;
            }
        });
    }

    public static Size getClosestSupportedSize(List<Size> supportedSizes, final int requestedWidth, final int requestedHeight) {
        return Collections.min(supportedSizes, new ClosestComparator<Size>(){

            @Override
            int diff(Size size) {
                return Math.abs(requestedWidth - size.width) + Math.abs(requestedHeight - size.height);
            }
        });
    }

    private static String getNameOfDevice(int facing) {
        Camera.CameraInfo info = new Camera.CameraInfo();
        for (int i = 0; i < Camera.getNumberOfCameras(); ++i) {
            try {
                Camera.getCameraInfo((int)i, (Camera.CameraInfo)info);
                if (info.facing != facing) continue;
                return CameraEnumerationAndroid.getDeviceName(i);
            }
            catch (Exception e) {
                Logging.e(TAG, "getCameraInfo() failed on index " + i, e);
            }
        }
        return null;
    }

    private static abstract class ClosestComparator<T>
    implements Comparator<T> {
        private ClosestComparator() {
        }

        abstract int diff(T var1);

        @Override
        public int compare(T t1, T t2) {
            return this.diff(t1) - this.diff(t2);
        }
    }

    public static class CaptureFormat {
        public final int width;
        public final int height;
        public final FramerateRange framerate;
        public final int imageFormat;

        public CaptureFormat(int width, int height, int minFramerate, int maxFramerate) {
            this(width, height, minFramerate, maxFramerate, 17);
        }

        public CaptureFormat(int width, int height, int minFramerate, int maxFramerate, int imageFormat) {
            this.width = width;
            this.height = height;
            this.framerate = new FramerateRange(minFramerate, maxFramerate);
            this.imageFormat = imageFormat;
        }

        public CaptureFormat(int width, int height, FramerateRange framerate) {
            this(width, height, framerate, 17);
        }

        public CaptureFormat(int width, int height, FramerateRange framerate, int imageFormat) {
            this.width = width;
            this.height = height;
            this.framerate = framerate;
            this.imageFormat = imageFormat;
        }

        public int frameSize() {
            return CaptureFormat.frameSize(this.width, this.height, this.imageFormat);
        }

        public static int frameSize(int width, int height, int imageFormat) {
            if (imageFormat != 17) {
                throw new UnsupportedOperationException("Don't know how to calculate the frame size of non-NV21 image formats.");
            }
            return width * height * ImageFormat.getBitsPerPixel((int)imageFormat) / 8;
        }

        public String toString() {
            return this.width + "x" + this.height + "@" + this.framerate;
        }

        public boolean equals(Object other) {
            if (!(other instanceof CaptureFormat)) {
                return false;
            }
            CaptureFormat otherFormat = (CaptureFormat)other;
            return this.width == otherFormat.width && this.height == otherFormat.height && this.framerate.equals(otherFormat.framerate);
        }

        public int hashCode() {
            return 1 + (this.width * 65497 + this.height) * 251 + this.framerate.hashCode();
        }

        public static class FramerateRange {
            public int min;
            public int max;

            public FramerateRange(int min, int max) {
                this.min = min;
                this.max = max;
            }

            public String toString() {
                return "[" + (float)this.min / 1000.0f + ":" + (float)this.max / 1000.0f + "]";
            }

            public boolean equals(Object other) {
                if (!(other instanceof FramerateRange)) {
                    return false;
                }
                FramerateRange otherFramerate = (FramerateRange)other;
                return this.min == otherFramerate.min && this.max == otherFramerate.max;
            }

            public int hashCode() {
                return 1 + 65537 * this.min + this.max;
            }
        }
    }
}

