/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import com.twilio.video.IceOptions;
import com.twilio.video.LocalMedia;

public class ConnectOptions {
    private final String roomName;
    private final LocalMedia localMedia;
    private final IceOptions iceOptions;

    private ConnectOptions(Builder builder) {
        this.roomName = builder.roomName;
        this.localMedia = builder.localMedia;
        this.iceOptions = builder.iceOptions;
    }

    String getRoomName() {
        return this.roomName;
    }

    LocalMedia getLocalMedia() {
        return this.localMedia;
    }

    IceOptions getIceOptions() {
        return this.iceOptions;
    }

    private long createNativeObject() {
        return this.nativeCreate(this.roomName, this.localMedia, this.iceOptions);
    }

    private native long nativeCreate(String var1, LocalMedia var2, IceOptions var3);

    public static class Builder {
        private String roomName = "";
        private LocalMedia localMedia;
        private IceOptions iceOptions;

        public Builder roomName(String roomName) {
            this.roomName = roomName;
            return this;
        }

        public Builder localMedia(LocalMedia localMedia) {
            this.localMedia = localMedia;
            return this;
        }

        public Builder iceOptions(IceOptions iceOptions) {
            this.iceOptions = iceOptions;
            return this;
        }

        public ConnectOptions build() {
            return new ConnectOptions(this);
        }
    }
}

