/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc.voiceengine;

import android.annotation.TargetApi;
import android.media.audiofx.AcousticEchoCanceler;
import android.media.audiofx.AudioEffect;
import android.media.audiofx.AutomaticGainControl;
import android.media.audiofx.NoiseSuppressor;
import android.os.Build;
import java.util.List;
import java.util.UUID;
import org.webrtc.Logging;
import org.webrtc.voiceengine.WebRtcAudioUtils;

class WebRtcAudioEffects {
    private static final boolean DEBUG = false;
    private static final String TAG = "WebRtcAudioEffects";
    private static final UUID AOSP_ACOUSTIC_ECHO_CANCELER = UUID.fromString("bb392ec0-8d4d-11e0-a896-0002a5d5c51b");
    private static final UUID AOSP_AUTOMATIC_GAIN_CONTROL = UUID.fromString("aa8130e0-66fc-11e0-bad0-0002a5d5c51b");
    private static final UUID AOSP_NOISE_SUPPRESSOR = UUID.fromString("c06c8400-8e06-11e0-9cb6-0002a5d5c51b");
    private static Boolean canUseAcousticEchoCanceler = null;
    private static Boolean canUseAutomaticGainControl = null;
    private static Boolean canUseNoiseSuppressor = null;
    private AcousticEchoCanceler aec = null;
    private AutomaticGainControl agc = null;
    private NoiseSuppressor ns = null;
    private boolean shouldEnableAec = false;
    private boolean shouldEnableAgc = false;
    private boolean shouldEnableNs = false;

    public static boolean isAcousticEchoCancelerSupported() {
        return WebRtcAudioUtils.runningOnJellyBeanOrHigher() && AcousticEchoCanceler.isAvailable();
    }

    public static boolean isAutomaticGainControlSupported() {
        return WebRtcAudioUtils.runningOnJellyBeanOrHigher() && AutomaticGainControl.isAvailable();
    }

    public static boolean isNoiseSuppressorSupported() {
        return WebRtcAudioUtils.runningOnJellyBeanOrHigher() && NoiseSuppressor.isAvailable();
    }

    public static boolean isAcousticEchoCancelerBlacklisted() {
        List<String> blackListedModels = WebRtcAudioUtils.getBlackListedModelsForAecUsage();
        boolean isBlacklisted = blackListedModels.contains(Build.MODEL);
        if (isBlacklisted) {
            Logging.w(TAG, Build.MODEL + " is blacklisted for HW AEC usage!");
        }
        return isBlacklisted;
    }

    public static boolean isAutomaticGainControlBlacklisted() {
        List<String> blackListedModels = WebRtcAudioUtils.getBlackListedModelsForAgcUsage();
        boolean isBlacklisted = blackListedModels.contains(Build.MODEL);
        if (isBlacklisted) {
            Logging.w(TAG, Build.MODEL + " is blacklisted for HW AGC usage!");
        }
        return isBlacklisted;
    }

    public static boolean isNoiseSuppressorBlacklisted() {
        List<String> blackListedModels = WebRtcAudioUtils.getBlackListedModelsForNsUsage();
        boolean isBlacklisted = blackListedModels.contains(Build.MODEL);
        if (isBlacklisted) {
            Logging.w(TAG, Build.MODEL + " is blacklisted for HW NS usage!");
        }
        return isBlacklisted;
    }

    @TargetApi(value=18)
    private static boolean isAcousticEchoCancelerExcludedByUUID() {
        for (AudioEffect.Descriptor d : AudioEffect.queryEffects()) {
            if (!d.type.equals(AudioEffect.EFFECT_TYPE_AEC) || !d.uuid.equals(AOSP_ACOUSTIC_ECHO_CANCELER)) continue;
            return true;
        }
        return false;
    }

    @TargetApi(value=18)
    private static boolean isAutomaticGainControlExcludedByUUID() {
        for (AudioEffect.Descriptor d : AudioEffect.queryEffects()) {
            if (!d.type.equals(AudioEffect.EFFECT_TYPE_AGC) || !d.uuid.equals(AOSP_AUTOMATIC_GAIN_CONTROL)) continue;
            return true;
        }
        return false;
    }

    @TargetApi(value=18)
    private static boolean isNoiseSuppressorExcludedByUUID() {
        for (AudioEffect.Descriptor d : AudioEffect.queryEffects()) {
            if (!d.type.equals(AudioEffect.EFFECT_TYPE_NS) || !d.uuid.equals(AOSP_NOISE_SUPPRESSOR)) continue;
            return true;
        }
        return false;
    }

    public static boolean canUseAcousticEchoCanceler() {
        if (canUseAcousticEchoCanceler == null) {
            canUseAcousticEchoCanceler = new Boolean(WebRtcAudioEffects.isAcousticEchoCancelerSupported() && !WebRtcAudioUtils.useWebRtcBasedAcousticEchoCanceler() && !WebRtcAudioEffects.isAcousticEchoCancelerBlacklisted() && !WebRtcAudioEffects.isAcousticEchoCancelerExcludedByUUID());
            Logging.d(TAG, "canUseAcousticEchoCanceler: " + canUseAcousticEchoCanceler);
        }
        return canUseAcousticEchoCanceler;
    }

    public static boolean canUseAutomaticGainControl() {
        if (canUseAutomaticGainControl == null) {
            canUseAutomaticGainControl = new Boolean(WebRtcAudioEffects.isAutomaticGainControlSupported() && !WebRtcAudioUtils.useWebRtcBasedAutomaticGainControl() && !WebRtcAudioEffects.isAutomaticGainControlBlacklisted() && !WebRtcAudioEffects.isAutomaticGainControlExcludedByUUID());
            Logging.d(TAG, "canUseAutomaticGainControl: " + canUseAutomaticGainControl);
        }
        return canUseAutomaticGainControl;
    }

    public static boolean canUseNoiseSuppressor() {
        if (canUseNoiseSuppressor == null) {
            canUseNoiseSuppressor = new Boolean(WebRtcAudioEffects.isNoiseSuppressorSupported() && !WebRtcAudioUtils.useWebRtcBasedNoiseSuppressor() && !WebRtcAudioEffects.isNoiseSuppressorBlacklisted() && !WebRtcAudioEffects.isNoiseSuppressorExcludedByUUID());
            Logging.d(TAG, "canUseNoiseSuppressor: " + canUseNoiseSuppressor);
        }
        return canUseNoiseSuppressor;
    }

    static WebRtcAudioEffects create() {
        if (!WebRtcAudioUtils.runningOnJellyBeanOrHigher()) {
            Logging.w(TAG, "API level 16 or higher is required!");
            return null;
        }
        return new WebRtcAudioEffects();
    }

    private WebRtcAudioEffects() {
        Logging.d(TAG, "ctor" + WebRtcAudioUtils.getThreadInfo());
    }

    public boolean setAEC(boolean enable) {
        Logging.d(TAG, "setAEC(" + enable + ")");
        if (!WebRtcAudioEffects.canUseAcousticEchoCanceler()) {
            Logging.w(TAG, "Platform AEC is not supported");
            this.shouldEnableAec = false;
            return false;
        }
        if (this.aec != null && enable != this.shouldEnableAec) {
            Logging.e(TAG, "Platform AEC state can't be modified while recording");
            return false;
        }
        this.shouldEnableAec = enable;
        return true;
    }

    public boolean setAGC(boolean enable) {
        Logging.d(TAG, "setAGC(" + enable + ")");
        if (!WebRtcAudioEffects.canUseAutomaticGainControl()) {
            Logging.w(TAG, "Platform AGC is not supported");
            this.shouldEnableAgc = false;
            return false;
        }
        if (this.agc != null && enable != this.shouldEnableAgc) {
            Logging.e(TAG, "Platform AGC state can't be modified while recording");
            return false;
        }
        this.shouldEnableAgc = enable;
        return true;
    }

    public boolean setNS(boolean enable) {
        Logging.d(TAG, "setNS(" + enable + ")");
        if (!WebRtcAudioEffects.canUseNoiseSuppressor()) {
            Logging.w(TAG, "Platform NS is not supported");
            this.shouldEnableNs = false;
            return false;
        }
        if (this.ns != null && enable != this.shouldEnableNs) {
            Logging.e(TAG, "Platform NS state can't be modified while recording");
            return false;
        }
        this.shouldEnableNs = enable;
        return true;
    }

    public void enable(int audioSession) {
        boolean enable;
        Logging.d(TAG, "enable(audioSession=" + audioSession + ")");
        WebRtcAudioEffects.assertTrue(this.aec == null);
        WebRtcAudioEffects.assertTrue(this.agc == null);
        WebRtcAudioEffects.assertTrue(this.ns == null);
        for (AudioEffect.Descriptor d : AudioEffect.queryEffects()) {
            if (!this.effectTypeIsVoIP(d.type)) continue;
            Logging.d(TAG, "name: " + d.name + ", mode: " + d.connectMode + ", implementor: " + d.implementor + ", UUID: " + d.uuid);
        }
        if (WebRtcAudioEffects.isAcousticEchoCancelerSupported()) {
            this.aec = AcousticEchoCanceler.create((int)audioSession);
            if (this.aec != null) {
                boolean enabled = this.aec.getEnabled();
                boolean bl = enable = this.shouldEnableAec && WebRtcAudioEffects.canUseAcousticEchoCanceler();
                if (this.aec.setEnabled(enable) != 0) {
                    Logging.e(TAG, "Failed to set the AcousticEchoCanceler state");
                }
                Logging.d(TAG, "AcousticEchoCanceler: was " + (enabled ? "enabled" : "disabled") + ", enable: " + enable + ", is now: " + (this.aec.getEnabled() ? "enabled" : "disabled"));
            } else {
                Logging.e(TAG, "Failed to create the AcousticEchoCanceler instance");
            }
        }
        if (WebRtcAudioEffects.isAutomaticGainControlSupported()) {
            this.agc = AutomaticGainControl.create((int)audioSession);
            if (this.agc != null) {
                boolean enabled = this.agc.getEnabled();
                boolean bl = enable = this.shouldEnableAgc && WebRtcAudioEffects.canUseAutomaticGainControl();
                if (this.agc.setEnabled(enable) != 0) {
                    Logging.e(TAG, "Failed to set the AutomaticGainControl state");
                }
                Logging.d(TAG, "AutomaticGainControl: was " + (enabled ? "enabled" : "disabled") + ", enable: " + enable + ", is now: " + (this.agc.getEnabled() ? "enabled" : "disabled"));
            } else {
                Logging.e(TAG, "Failed to create the AutomaticGainControl instance");
            }
        }
        if (WebRtcAudioEffects.isNoiseSuppressorSupported()) {
            this.ns = NoiseSuppressor.create((int)audioSession);
            if (this.ns != null) {
                boolean enabled = this.ns.getEnabled();
                boolean bl = enable = this.shouldEnableNs && WebRtcAudioEffects.canUseNoiseSuppressor();
                if (this.ns.setEnabled(enable) != 0) {
                    Logging.e(TAG, "Failed to set the NoiseSuppressor state");
                }
                Logging.d(TAG, "NoiseSuppressor: was " + (enabled ? "enabled" : "disabled") + ", enable: " + enable + ", is now: " + (this.ns.getEnabled() ? "enabled" : "disabled"));
            } else {
                Logging.e(TAG, "Failed to create the NoiseSuppressor instance");
            }
        }
    }

    public void release() {
        Logging.d(TAG, "release");
        if (this.aec != null) {
            this.aec.release();
            this.aec = null;
        }
        if (this.agc != null) {
            this.agc.release();
            this.agc = null;
        }
        if (this.ns != null) {
            this.ns.release();
            this.ns = null;
        }
    }

    @TargetApi(value=18)
    private boolean effectTypeIsVoIP(UUID type) {
        if (!WebRtcAudioUtils.runningOnJellyBeanMR2OrHigher()) {
            return false;
        }
        return AudioEffect.EFFECT_TYPE_AEC.equals(type) && WebRtcAudioEffects.isAcousticEchoCancelerSupported() || AudioEffect.EFFECT_TYPE_AGC.equals(type) && WebRtcAudioEffects.isAutomaticGainControlSupported() || AudioEffect.EFFECT_TYPE_NS.equals(type) && WebRtcAudioEffects.isNoiseSuppressorSupported();
    }

    private static void assertTrue(boolean condition) {
        if (!condition) {
            throw new AssertionError((Object)"Expected condition to be true");
        }
    }
}

