/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import android.content.Context;
import com.twilio.video.CameraCapturer;
import com.twilio.video.VideoCapturer;
import com.twilio.video.VideoCapturerListenerAdapter;
import com.twilio.video.VideoDimensions;
import com.twilio.video.VideoFormat;
import com.twilio.video.VideoPixelFormat;
import java.util.ArrayList;
import java.util.List;
import org.webrtc.CameraEnumerationAndroid;
import org.webrtc.SurfaceTextureHelper;
import org.webrtc.VideoCapturer;

final class VideoCapturerDelegate
implements org.webrtc.VideoCapturer {
    private final VideoCapturer videoCapturer;
    private VideoPixelFormat videoPixelFormat;

    VideoCapturerDelegate(VideoCapturer videoCapturer) {
        this.videoCapturer = videoCapturer;
    }

    public List<CameraEnumerationAndroid.CaptureFormat> getSupportedFormats() {
        return this.convertToWebRtcFormats(this.videoCapturer.getSupportedFormats());
    }

    public void startCapture(int width, int height, int framerate, SurfaceTextureHelper surfaceTextureHelper, Context context, VideoCapturer.CapturerObserver capturerObserver) {
        if (this.videoCapturer instanceof CameraCapturer) {
            CameraCapturer cameraCapturer = (CameraCapturer)this.videoCapturer;
            cameraCapturer.setSurfaceTextureHelper(surfaceTextureHelper);
        }
        VideoDimensions dimensions = new VideoDimensions(width, height);
        VideoFormat captureFormat = new VideoFormat(dimensions, framerate, this.videoPixelFormat);
        VideoCapturerListenerAdapter listenerAdapter = new VideoCapturerListenerAdapter(capturerObserver);
        this.videoCapturer.startCapture(captureFormat, listenerAdapter);
    }

    public void stopCapture() throws InterruptedException {
        this.videoCapturer.stopCapture();
    }

    public void dispose() {
    }

    private void setVideoPixelFormat(VideoPixelFormat videoPixelFormat) {
        this.videoPixelFormat = videoPixelFormat;
    }

    private List<CameraEnumerationAndroid.CaptureFormat> convertToWebRtcFormats(List<VideoFormat> videoFormats) {
        if (videoFormats != null) {
            ArrayList<CameraEnumerationAndroid.CaptureFormat> webRtcCaptureFormats = new ArrayList<CameraEnumerationAndroid.CaptureFormat>(videoFormats.size());
            for (int i = 0; i < videoFormats.size(); ++i) {
                VideoFormat videoFormat = videoFormats.get(i);
                CameraEnumerationAndroid.CaptureFormat webRtcCaptureFormat = new CameraEnumerationAndroid.CaptureFormat(videoFormat.dimensions.width, videoFormat.dimensions.height, videoFormat.framerate, videoFormat.framerate, videoFormat.pixelFormat.getValue());
                webRtcCaptureFormats.add(i, webRtcCaptureFormat);
            }
            return webRtcCaptureFormats;
        }
        return new ArrayList<CameraEnumerationAndroid.CaptureFormat>();
    }
}

