/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.annotation.SuppressLint;
import android.graphics.Point;
import android.graphics.Rect;
import android.opengl.EGL14;
import android.opengl.GLES20;
import android.opengl.GLSurfaceView;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.opengles.GL10;
import org.webrtc.EglBase;
import org.webrtc.EglBase10;
import org.webrtc.EglBase14;
import org.webrtc.GlRectDrawer;
import org.webrtc.GlTextureFrameBuffer;
import org.webrtc.GlUtil;
import org.webrtc.Logging;
import org.webrtc.RendererCommon;
import org.webrtc.VideoRenderer;

public class VideoRendererGui
implements GLSurfaceView.Renderer {
    private static VideoRendererGui instance = null;
    private static Runnable eglContextReady = null;
    private static final String TAG = "VideoRendererGui";
    private GLSurfaceView surface;
    private static EglBase.Context eglContext = null;
    private boolean onSurfaceCreatedCalled;
    private int screenWidth;
    private int screenHeight;
    private final ArrayList<YuvImageRenderer> yuvImageRenderers;
    private static Thread renderFrameThread;
    private static Thread drawThread;

    private VideoRendererGui(GLSurfaceView surface) {
        this.surface = surface;
        surface.setPreserveEGLContextOnPause(true);
        surface.setEGLContextClientVersion(2);
        surface.setRenderer((GLSurfaceView.Renderer)this);
        surface.setRenderMode(0);
        this.yuvImageRenderers = new ArrayList();
    }

    public static synchronized void setView(GLSurfaceView surface, Runnable eglContextReadyCallback) {
        Logging.d(TAG, "VideoRendererGui.setView");
        instance = new VideoRendererGui(surface);
        eglContextReady = eglContextReadyCallback;
    }

    public static synchronized EglBase.Context getEglBaseContext() {
        return eglContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void dispose() {
        if (instance == null) {
            return;
        }
        Logging.d(TAG, "VideoRendererGui.dispose");
        ArrayList<YuvImageRenderer> arrayList = VideoRendererGui.instance.yuvImageRenderers;
        synchronized (arrayList) {
            for (YuvImageRenderer yuvImageRenderer : VideoRendererGui.instance.yuvImageRenderers) {
                yuvImageRenderer.release();
            }
            VideoRendererGui.instance.yuvImageRenderers.clear();
        }
        renderFrameThread = null;
        drawThread = null;
        VideoRendererGui.instance.surface = null;
        eglContext = null;
        eglContextReady = null;
        instance = null;
    }

    public static VideoRenderer createGui(int x, int y, int width, int height, RendererCommon.ScalingType scalingType, boolean mirror) throws Exception {
        YuvImageRenderer javaGuiRenderer = VideoRendererGui.create(x, y, width, height, scalingType, mirror);
        return new VideoRenderer(javaGuiRenderer);
    }

    public static VideoRenderer.Callbacks createGuiRenderer(int x, int y, int width, int height, RendererCommon.ScalingType scalingType, boolean mirror) {
        return VideoRendererGui.create(x, y, width, height, scalingType, mirror);
    }

    public static synchronized YuvImageRenderer create(int x, int y, int width, int height, RendererCommon.ScalingType scalingType, boolean mirror) {
        return VideoRendererGui.create(x, y, width, height, scalingType, mirror, new GlRectDrawer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized YuvImageRenderer create(int x, int y, int width, int height, RendererCommon.ScalingType scalingType, boolean mirror, RendererCommon.GlDrawer drawer) {
        if (x < 0 || x > 100 || y < 0 || y > 100 || width < 0 || width > 100 || height < 0 || height > 100 || x + width > 100 || y + height > 100) {
            throw new RuntimeException("Incorrect window parameters.");
        }
        if (instance == null) {
            throw new RuntimeException("Attempt to create yuv renderer before setting GLSurfaceView");
        }
        final YuvImageRenderer yuvImageRenderer = new YuvImageRenderer(VideoRendererGui.instance.surface, VideoRendererGui.instance.yuvImageRenderers.size(), x, y, width, height, scalingType, mirror, drawer);
        ArrayList<YuvImageRenderer> arrayList = VideoRendererGui.instance.yuvImageRenderers;
        synchronized (arrayList) {
            if (VideoRendererGui.instance.onSurfaceCreatedCalled) {
                final CountDownLatch countDownLatch = new CountDownLatch(1);
                VideoRendererGui.instance.surface.queueEvent(new Runnable(){

                    @Override
                    public void run() {
                        yuvImageRenderer.createTextures();
                        yuvImageRenderer.setScreenSize(instance.screenWidth, instance.screenHeight);
                        countDownLatch.countDown();
                    }
                });
                try {
                    countDownLatch.await();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            VideoRendererGui.instance.yuvImageRenderers.add(yuvImageRenderer);
        }
        return yuvImageRenderer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void update(VideoRenderer.Callbacks renderer, int x, int y, int width, int height, RendererCommon.ScalingType scalingType, boolean mirror) {
        Logging.d(TAG, "VideoRendererGui.update");
        if (instance == null) {
            throw new RuntimeException("Attempt to update yuv renderer before setting GLSurfaceView");
        }
        ArrayList<YuvImageRenderer> arrayList = VideoRendererGui.instance.yuvImageRenderers;
        synchronized (arrayList) {
            for (YuvImageRenderer yuvImageRenderer : VideoRendererGui.instance.yuvImageRenderers) {
                if (yuvImageRenderer != renderer) continue;
                yuvImageRenderer.setPosition(x, y, width, height, scalingType, mirror);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void setRendererEvents(VideoRenderer.Callbacks renderer, RendererCommon.RendererEvents rendererEvents) {
        Logging.d(TAG, "VideoRendererGui.setRendererEvents");
        if (instance == null) {
            throw new RuntimeException("Attempt to set renderer events before setting GLSurfaceView");
        }
        ArrayList<YuvImageRenderer> arrayList = VideoRendererGui.instance.yuvImageRenderers;
        synchronized (arrayList) {
            for (YuvImageRenderer yuvImageRenderer : VideoRendererGui.instance.yuvImageRenderers) {
                if (yuvImageRenderer != renderer) continue;
                yuvImageRenderer.rendererEvents = rendererEvents;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void remove(VideoRenderer.Callbacks renderer) {
        Logging.d(TAG, "VideoRendererGui.remove");
        if (instance == null) {
            throw new RuntimeException("Attempt to remove renderer before setting GLSurfaceView");
        }
        ArrayList<YuvImageRenderer> arrayList = VideoRendererGui.instance.yuvImageRenderers;
        synchronized (arrayList) {
            int index = VideoRendererGui.instance.yuvImageRenderers.indexOf(renderer);
            if (index == -1) {
                Logging.w(TAG, "Couldn't remove renderer (not present in current list)");
            } else {
                VideoRendererGui.instance.yuvImageRenderers.remove(index).release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void reset(VideoRenderer.Callbacks renderer) {
        Logging.d(TAG, "VideoRendererGui.reset");
        if (instance == null) {
            throw new RuntimeException("Attempt to reset renderer before setting GLSurfaceView");
        }
        ArrayList<YuvImageRenderer> arrayList = VideoRendererGui.instance.yuvImageRenderers;
        synchronized (arrayList) {
            for (YuvImageRenderer yuvImageRenderer : VideoRendererGui.instance.yuvImageRenderers) {
                if (yuvImageRenderer != renderer) continue;
                yuvImageRenderer.reset();
            }
        }
    }

    private static void printStackTrace(Thread thread, String threadName) {
        StackTraceElement[] stackTraces;
        if (thread != null && (stackTraces = thread.getStackTrace()).length > 0) {
            Logging.d(TAG, threadName + " stacks trace:");
            for (StackTraceElement stackTrace : stackTraces) {
                Logging.d(TAG, stackTrace.toString());
            }
        }
    }

    public static synchronized void printStackTraces() {
        if (instance == null) {
            return;
        }
        VideoRendererGui.printStackTrace(renderFrameThread, "Render frame thread");
        VideoRendererGui.printStackTrace(drawThread, "Draw thread");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"NewApi"})
    public void onSurfaceCreated(GL10 unused, EGLConfig config) {
        Logging.d(TAG, "VideoRendererGui.onSurfaceCreated");
        Class<VideoRendererGui> clazz = VideoRendererGui.class;
        synchronized (VideoRendererGui.class) {
            eglContext = EglBase14.isEGL14Supported() ? new EglBase14.Context(EGL14.eglGetCurrentContext()) : new EglBase10.Context(((EGL10)EGLContext.getEGL()).eglGetCurrentContext());
            Logging.d(TAG, "VideoRendererGui EGL Context: " + eglContext);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            clazz = this.yuvImageRenderers;
            synchronized (clazz) {
                for (YuvImageRenderer yuvImageRenderer : this.yuvImageRenderers) {
                    yuvImageRenderer.createTextures();
                }
                this.onSurfaceCreatedCalled = true;
            }
            GlUtil.checkNoGLES2Error("onSurfaceCreated done");
            GLES20.glPixelStorei((int)3317, (int)1);
            GLES20.glClearColor((float)0.15f, (float)0.15f, (float)0.15f, (float)1.0f);
            clazz = VideoRendererGui.class;
            synchronized (VideoRendererGui.class) {
                if (eglContextReady != null) {
                    eglContextReady.run();
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSurfaceChanged(GL10 unused, int width, int height) {
        Logging.d(TAG, "VideoRendererGui.onSurfaceChanged: " + width + " x " + height + "  ");
        this.screenWidth = width;
        this.screenHeight = height;
        ArrayList<YuvImageRenderer> arrayList = this.yuvImageRenderers;
        synchronized (arrayList) {
            for (YuvImageRenderer yuvImageRenderer : this.yuvImageRenderers) {
                yuvImageRenderer.setScreenSize(this.screenWidth, this.screenHeight);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDrawFrame(GL10 unused) {
        if (drawThread == null) {
            drawThread = Thread.currentThread();
        }
        GLES20.glViewport((int)0, (int)0, (int)this.screenWidth, (int)this.screenHeight);
        GLES20.glClear((int)16384);
        ArrayList<YuvImageRenderer> arrayList = this.yuvImageRenderers;
        synchronized (arrayList) {
            for (YuvImageRenderer yuvImageRenderer : this.yuvImageRenderers) {
                yuvImageRenderer.draw();
            }
        }
    }

    private static class YuvImageRenderer
    implements VideoRenderer.Callbacks {
        private GLSurfaceView surface;
        private int id;
        private int[] yuvTextures = new int[]{0, 0, 0};
        private final RendererCommon.YuvUploader yuvUploader = new RendererCommon.YuvUploader();
        private final RendererCommon.GlDrawer drawer;
        private GlTextureFrameBuffer textureCopy;
        private VideoRenderer.I420Frame pendingFrame;
        private final Object pendingFrameLock = new Object();
        private RendererType rendererType;
        private RendererCommon.ScalingType scalingType;
        private boolean mirror;
        private RendererCommon.RendererEvents rendererEvents;
        boolean seenFrame;
        private int framesReceived;
        private int framesDropped;
        private int framesRendered;
        private long startTimeNs = -1L;
        private long drawTimeNs;
        private long copyTimeNs;
        private final Rect layoutInPercentage;
        private final Rect displayLayout = new Rect();
        private float[] layoutMatrix;
        private boolean updateLayoutProperties;
        private final Object updateLayoutLock = new Object();
        private float[] rotatedSamplingMatrix;
        private int screenWidth;
        private int screenHeight;
        private int videoWidth;
        private int videoHeight;
        private int rotationDegree;

        private YuvImageRenderer(GLSurfaceView surface, int id, int x, int y, int width, int height, RendererCommon.ScalingType scalingType, boolean mirror, RendererCommon.GlDrawer drawer) {
            Logging.d(VideoRendererGui.TAG, "YuvImageRenderer.Create id: " + id);
            this.surface = surface;
            this.id = id;
            this.scalingType = scalingType;
            this.mirror = mirror;
            this.drawer = drawer;
            this.layoutInPercentage = new Rect(x, y, Math.min(100, x + width), Math.min(100, y + height));
            this.updateLayoutProperties = false;
            this.rotationDegree = 0;
        }

        public synchronized void reset() {
            this.seenFrame = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void release() {
            this.surface = null;
            this.drawer.release();
            Object object = this.pendingFrameLock;
            synchronized (object) {
                if (this.pendingFrame != null) {
                    VideoRenderer.renderFrameDone(this.pendingFrame);
                    this.pendingFrame = null;
                }
            }
        }

        private void createTextures() {
            Logging.d(VideoRendererGui.TAG, "  YuvImageRenderer.createTextures " + this.id + " on GL thread:" + Thread.currentThread().getId());
            for (int i = 0; i < 3; ++i) {
                this.yuvTextures[i] = GlUtil.generateTexture(3553);
            }
            this.textureCopy = new GlTextureFrameBuffer(6407);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateLayoutMatrix() {
            Object object = this.updateLayoutLock;
            synchronized (object) {
                if (!this.updateLayoutProperties) {
                    return;
                }
                this.displayLayout.set((this.screenWidth * this.layoutInPercentage.left + 99) / 100, (this.screenHeight * this.layoutInPercentage.top + 99) / 100, this.screenWidth * this.layoutInPercentage.right / 100, this.screenHeight * this.layoutInPercentage.bottom / 100);
                Logging.d(VideoRendererGui.TAG, "ID: " + this.id + ". AdjustTextureCoords. Allowed display size: " + this.displayLayout.width() + " x " + this.displayLayout.height() + ". Video: " + this.videoWidth + " x " + this.videoHeight + ". Rotation: " + this.rotationDegree + ". Mirror: " + this.mirror);
                float videoAspectRatio = this.rotationDegree % 180 == 0 ? (float)this.videoWidth / (float)this.videoHeight : (float)this.videoHeight / (float)this.videoWidth;
                Point displaySize = RendererCommon.getDisplaySize(this.scalingType, videoAspectRatio, this.displayLayout.width(), this.displayLayout.height());
                this.displayLayout.inset((this.displayLayout.width() - displaySize.x) / 2, (this.displayLayout.height() - displaySize.y) / 2);
                Logging.d(VideoRendererGui.TAG, "  Adjusted display size: " + this.displayLayout.width() + " x " + this.displayLayout.height());
                this.layoutMatrix = RendererCommon.getLayoutMatrix(this.mirror, videoAspectRatio, (float)this.displayLayout.width() / (float)this.displayLayout.height());
                this.updateLayoutProperties = false;
                Logging.d(VideoRendererGui.TAG, "  AdjustTextureCoords done");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void draw() {
            boolean isNewFrame;
            if (!this.seenFrame) {
                return;
            }
            long now = System.nanoTime();
            Object object = this.pendingFrameLock;
            synchronized (object) {
                boolean bl = isNewFrame = this.pendingFrame != null;
                if (isNewFrame && this.startTimeNs == -1L) {
                    this.startTimeNs = now;
                }
                if (isNewFrame) {
                    this.rotatedSamplingMatrix = RendererCommon.rotateTextureMatrix(this.pendingFrame.samplingMatrix, this.pendingFrame.rotationDegree);
                    if (this.pendingFrame.yuvFrame) {
                        this.rendererType = RendererType.RENDERER_YUV;
                        this.yuvUploader.uploadYuvData(this.yuvTextures, this.pendingFrame.width, this.pendingFrame.height, this.pendingFrame.yuvStrides, this.pendingFrame.yuvPlanes);
                    } else {
                        this.rendererType = RendererType.RENDERER_TEXTURE;
                        this.textureCopy.setSize(this.pendingFrame.rotatedWidth(), this.pendingFrame.rotatedHeight());
                        GLES20.glBindFramebuffer((int)36160, (int)this.textureCopy.getFrameBufferId());
                        GlUtil.checkNoGLES2Error("glBindFramebuffer");
                        this.drawer.drawOes(this.pendingFrame.textureId, this.rotatedSamplingMatrix, this.textureCopy.getWidth(), this.textureCopy.getHeight(), 0, 0, this.textureCopy.getWidth(), this.textureCopy.getHeight());
                        this.rotatedSamplingMatrix = RendererCommon.identityMatrix();
                        GLES20.glBindFramebuffer((int)36160, (int)0);
                        GLES20.glFinish();
                    }
                    this.copyTimeNs += System.nanoTime() - now;
                    VideoRenderer.renderFrameDone(this.pendingFrame);
                    this.pendingFrame = null;
                }
            }
            this.updateLayoutMatrix();
            float[] texMatrix = RendererCommon.multiplyMatrices(this.rotatedSamplingMatrix, this.layoutMatrix);
            int viewportY = this.screenHeight - this.displayLayout.bottom;
            if (this.rendererType == RendererType.RENDERER_YUV) {
                this.drawer.drawYuv(this.yuvTextures, texMatrix, this.videoWidth, this.videoHeight, this.displayLayout.left, viewportY, this.displayLayout.width(), this.displayLayout.height());
            } else {
                this.drawer.drawRgb(this.textureCopy.getTextureId(), texMatrix, this.videoWidth, this.videoHeight, this.displayLayout.left, viewportY, this.displayLayout.width(), this.displayLayout.height());
            }
            if (isNewFrame) {
                ++this.framesRendered;
                this.drawTimeNs += System.nanoTime() - now;
                if (this.framesRendered % 300 == 0) {
                    this.logStatistics();
                }
            }
        }

        private void logStatistics() {
            long timeSinceFirstFrameNs = System.nanoTime() - this.startTimeNs;
            Logging.d(VideoRendererGui.TAG, "ID: " + this.id + ". Type: " + (Object)((Object)this.rendererType) + ". Frames received: " + this.framesReceived + ". Dropped: " + this.framesDropped + ". Rendered: " + this.framesRendered);
            if (this.framesReceived > 0 && this.framesRendered > 0) {
                Logging.d(VideoRendererGui.TAG, "Duration: " + (int)((double)timeSinceFirstFrameNs / 1000000.0) + " ms. FPS: " + (double)this.framesRendered * 1.0E9 / (double)timeSinceFirstFrameNs);
                Logging.d(VideoRendererGui.TAG, "Draw time: " + (int)(this.drawTimeNs / (long)(1000 * this.framesRendered)) + " us. Copy time: " + (int)(this.copyTimeNs / (long)(1000 * this.framesReceived)) + " us");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setScreenSize(int screenWidth, int screenHeight) {
            Object object = this.updateLayoutLock;
            synchronized (object) {
                if (screenWidth == this.screenWidth && screenHeight == this.screenHeight) {
                    return;
                }
                Logging.d(VideoRendererGui.TAG, "ID: " + this.id + ". YuvImageRenderer.setScreenSize: " + screenWidth + " x " + screenHeight);
                this.screenWidth = screenWidth;
                this.screenHeight = screenHeight;
                this.updateLayoutProperties = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setPosition(int x, int y, int width, int height, RendererCommon.ScalingType scalingType, boolean mirror) {
            Rect layoutInPercentage = new Rect(x, y, Math.min(100, x + width), Math.min(100, y + height));
            Object object = this.updateLayoutLock;
            synchronized (object) {
                if (layoutInPercentage.equals((Object)this.layoutInPercentage) && scalingType == this.scalingType && mirror == this.mirror) {
                    return;
                }
                Logging.d(VideoRendererGui.TAG, "ID: " + this.id + ". YuvImageRenderer.setPosition: (" + x + ", " + y + ") " + width + " x " + height + ". Scaling: " + (Object)((Object)scalingType) + ". Mirror: " + mirror);
                this.layoutInPercentage.set(layoutInPercentage);
                this.scalingType = scalingType;
                this.mirror = mirror;
                this.updateLayoutProperties = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setSize(int videoWidth, int videoHeight, int rotation) {
            if (videoWidth == this.videoWidth && videoHeight == this.videoHeight && rotation == this.rotationDegree) {
                return;
            }
            if (this.rendererEvents != null) {
                Logging.d(VideoRendererGui.TAG, "ID: " + this.id + ". Reporting frame resolution changed to " + videoWidth + " x " + videoHeight);
                this.rendererEvents.onFrameResolutionChanged(videoWidth, videoHeight, rotation);
            }
            Object object = this.updateLayoutLock;
            synchronized (object) {
                Logging.d(VideoRendererGui.TAG, "ID: " + this.id + ". YuvImageRenderer.setSize: " + videoWidth + " x " + videoHeight + " rotation " + rotation);
                this.videoWidth = videoWidth;
                this.videoHeight = videoHeight;
                this.rotationDegree = rotation;
                this.updateLayoutProperties = true;
                Logging.d(VideoRendererGui.TAG, "  YuvImageRenderer.setSize done.");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void renderFrame(VideoRenderer.I420Frame frame) {
            if (this.surface == null) {
                VideoRenderer.renderFrameDone(frame);
                return;
            }
            if (renderFrameThread == null) {
                renderFrameThread = Thread.currentThread();
            }
            if (!this.seenFrame && this.rendererEvents != null) {
                Logging.d(VideoRendererGui.TAG, "ID: " + this.id + ". Reporting first rendered frame.");
                this.rendererEvents.onFirstFrameRendered();
            }
            ++this.framesReceived;
            Object object = this.pendingFrameLock;
            synchronized (object) {
                if (frame.yuvFrame && (frame.yuvStrides[0] < frame.width || frame.yuvStrides[1] < frame.width / 2 || frame.yuvStrides[2] < frame.width / 2)) {
                    Logging.e(VideoRendererGui.TAG, "Incorrect strides " + frame.yuvStrides[0] + ", " + frame.yuvStrides[1] + ", " + frame.yuvStrides[2]);
                    VideoRenderer.renderFrameDone(frame);
                    return;
                }
                if (this.pendingFrame != null) {
                    ++this.framesDropped;
                    VideoRenderer.renderFrameDone(frame);
                    this.seenFrame = true;
                    return;
                }
                this.pendingFrame = frame;
            }
            this.setSize(frame.width, frame.height, frame.rotationDegree);
            this.seenFrame = true;
            this.surface.requestRender();
        }

        private static enum RendererType {
            RENDERER_YUV,
            RENDERER_TEXTURE;

        }
    }
}

