/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import com.twilio.video.I420Frame;
import com.twilio.video.Logger;
import com.twilio.video.Track;
import com.twilio.video.VideoRenderer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.webrtc.VideoRenderer;

public class VideoTrack
implements Track {
    private static final String WARNING_NULL_RENDERER = "Attempted to add a null renderer.";
    private static final Logger logger = Logger.getLogger(VideoTrack.class);
    private final org.webrtc.VideoTrack webrtcVideoTrack;
    private final String trackId;
    private Map<VideoRenderer, org.webrtc.VideoRenderer> videoRenderersMap = new HashMap<VideoRenderer, org.webrtc.VideoRenderer>();
    private boolean isEnabled;
    private boolean isReleased = false;

    VideoTrack(org.webrtc.VideoTrack webRtcVideoTrack) {
        this.webrtcVideoTrack = webRtcVideoTrack;
        this.trackId = webRtcVideoTrack.id();
        this.isEnabled = webRtcVideoTrack.enabled();
    }

    public synchronized void addRenderer(VideoRenderer videoRenderer) {
        if (this.isReleased) {
            logger.w("Cannot add renderer. Video track has been removed.");
            return;
        }
        if (videoRenderer != null) {
            org.webrtc.VideoRenderer webrtcVideoRenderer = this.createWebRtcVideoRenderer(videoRenderer);
            this.videoRenderersMap.put(videoRenderer, webrtcVideoRenderer);
            this.webrtcVideoTrack.addRenderer(webrtcVideoRenderer);
        } else {
            logger.w(WARNING_NULL_RENDERER);
        }
    }

    public synchronized void removeRenderer(VideoRenderer videoRenderer) {
        if (!this.isReleased && videoRenderer != null) {
            org.webrtc.VideoRenderer webrtcVideoRenderer = this.videoRenderersMap.remove(videoRenderer);
            if (this.webrtcVideoTrack != null && webrtcVideoRenderer != null) {
                this.webrtcVideoTrack.removeRenderer(webrtcVideoRenderer);
            }
        }
    }

    public List<VideoRenderer> getRenderers() {
        return new ArrayList<VideoRenderer>(this.videoRenderersMap.keySet());
    }

    @Override
    public String getTrackId() {
        return this.trackId;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    private org.webrtc.VideoRenderer createWebRtcVideoRenderer(VideoRenderer videoRenderer) {
        return new org.webrtc.VideoRenderer((VideoRenderer.Callbacks)new VideoRendererCallbackAdapter(videoRenderer));
    }

    void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    synchronized void release() {
        if (!this.isReleased) {
            this.isEnabled = false;
            for (org.webrtc.VideoRenderer videoRenderer : this.videoRenderersMap.values()) {
                this.webrtcVideoTrack.removeRenderer(videoRenderer);
            }
            this.videoRenderersMap.clear();
            this.isReleased = true;
        }
    }

    private class VideoRendererCallbackAdapter
    implements VideoRenderer.Callbacks {
        private final VideoRenderer videoRenderer;

        public VideoRendererCallbackAdapter(VideoRenderer videoRenderer) {
            this.videoRenderer = videoRenderer;
        }

        public void renderFrame(VideoRenderer.I420Frame frame) {
            this.videoRenderer.renderFrame(new I420Frame(frame));
        }
    }
}

