/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.content.Context;
import java.util.List;
import org.webrtc.CameraEnumerationAndroid;
import org.webrtc.SurfaceTextureHelper;

public interface VideoCapturer {
    public List<CameraEnumerationAndroid.CaptureFormat> getSupportedFormats();

    public void startCapture(int var1, int var2, int var3, SurfaceTextureHelper var4, Context var5, CapturerObserver var6);

    public void stopCapture() throws InterruptedException;

    public void dispose();

    public static class NativeObserver
    implements CapturerObserver {
        private final long nativeCapturer;

        public NativeObserver(long nativeCapturer) {
            this.nativeCapturer = nativeCapturer;
        }

        @Override
        public void onCapturerStarted(boolean success) {
            this.nativeCapturerStarted(this.nativeCapturer, success);
        }

        @Override
        public void onByteBufferFrameCaptured(byte[] data, int width, int height, int rotation, long timeStamp) {
            this.nativeOnByteBufferFrameCaptured(this.nativeCapturer, data, data.length, width, height, rotation, timeStamp);
        }

        @Override
        public void onTextureFrameCaptured(int width, int height, int oesTextureId, float[] transformMatrix, int rotation, long timestamp) {
            this.nativeOnTextureFrameCaptured(this.nativeCapturer, width, height, oesTextureId, transformMatrix, rotation, timestamp);
        }

        @Override
        public void onOutputFormatRequest(int width, int height, int framerate) {
            this.nativeOnOutputFormatRequest(this.nativeCapturer, width, height, framerate);
        }

        private native void nativeCapturerStarted(long var1, boolean var3);

        private native void nativeOnByteBufferFrameCaptured(long var1, byte[] var3, int var4, int var5, int var6, int var7, long var8);

        private native void nativeOnTextureFrameCaptured(long var1, int var3, int var4, int var5, float[] var6, int var7, long var8);

        private native void nativeOnOutputFormatRequest(long var1, int var3, int var4, int var5);
    }

    public static interface CapturerObserver {
        public void onCapturerStarted(boolean var1);

        public void onByteBufferFrameCaptured(byte[] var1, int var2, int var3, int var4, long var5);

        public void onTextureFrameCaptured(int var1, int var2, int var3, float[] var4, int var5, long var6);

        public void onOutputFormatRequest(int var1, int var2, int var3);
    }
}

