/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import android.content.Context;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.util.Pair;
import com.twilio.video.ConnectOptions;
import com.twilio.video.LocalMedia;
import com.twilio.video.LocalParticipant;
import com.twilio.video.Logger;
import com.twilio.video.MediaFactory;
import com.twilio.video.NativeHandle;
import com.twilio.video.Participant;
import com.twilio.video.RoomState;
import com.twilio.video.StatsListener;
import com.twilio.video.StatsReport;
import com.twilio.video.TwilioException;
import com.twilio.video.Util;
import com.twilio.video.VideoClient;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class Room {
    private static final Logger logger = Logger.getLogger(Room.class);
    public static final int ERROR_INVALID_ACCESS_TOKEN = 20101;
    public static final int ERROR_ROOM_SIGNALING = 53100;
    public static final int ERROR_CREATE_PEERCONNECTION_FAILURE = 54001;
    public static final int ERROR_ICE_CONNECTION_FAILURE = 54101;
    public static final int ERROR_CREATE_LOCAL_SDP_FAILURE = 54102;
    public static final int ERROR_SET_LOCAL_SDP_FAILURE = 54103;
    public static final int ERROR_EMPTY_LOCAL_SDP = 54104;
    public static final int ERROR_PROCESS_REMOTE_SDP_FAILURE = 54105;
    public static final int ERROR_SET_REMOTE_SDP_FAILURE = 54106;
    private long nativeRoomContext;
    private String name;
    private final LocalMedia localMedia;
    private String sid;
    private RoomState roomState;
    private Map<String, Participant> participantMap = new HashMap<String, Participant>();
    private InternalRoomListenerHandle internalRoomListenerHandle;
    private InternalRoomListenerImpl internalRoomListenerImpl;
    private InternalStatsListenerHandle internalStatsListenerHandle;
    private InternalStatsListenerImpl internalStatsListenerImpl;
    private LocalParticipant localParticipant;
    private final Listener listener;
    private final Handler handler;
    private Queue<Pair<Handler, StatsListener>> statsListenersQueue;

    Room(String name, LocalMedia localMedia, Listener listener, Handler handler) {
        this.name = name;
        this.localMedia = localMedia;
        this.sid = "";
        this.roomState = RoomState.DISCONNECTED;
        this.listener = listener;
        this.internalRoomListenerImpl = new InternalRoomListenerImpl();
        this.internalRoomListenerHandle = new InternalRoomListenerHandle(this.internalRoomListenerImpl);
        this.handler = handler;
        this.statsListenersQueue = new ConcurrentLinkedQueue<Pair<Handler, StatsListener>>();
    }

    public String getName() {
        return this.name;
    }

    public String getSid() {
        return this.sid;
    }

    public RoomState getState() {
        return this.roomState;
    }

    public boolean isRecording() {
        return this.roomState == RoomState.CONNECTED ? this.nativeIsRecording(this.nativeRoomContext) : false;
    }

    public Map<String, Participant> getParticipants() {
        return new HashMap<String, Participant>(this.participantMap);
    }

    public LocalParticipant getLocalParticipant() {
        return this.localParticipant;
    }

    public synchronized void getStats(@NonNull StatsListener statsListener) {
        if (statsListener == null) {
            throw new NullPointerException("StatsListener must not be null");
        }
        if (this.roomState == RoomState.DISCONNECTED) {
            return;
        }
        if (this.internalStatsListenerImpl == null) {
            this.internalStatsListenerImpl = new InternalStatsListenerImpl();
            this.internalStatsListenerHandle = new InternalStatsListenerHandle(this.internalStatsListenerImpl);
        }
        this.statsListenersQueue.offer((Pair<Handler, StatsListener>)new Pair((Object)Util.createCallbackHandler(), (Object)statsListener));
        this.nativeGetStats(this.nativeRoomContext, this.internalStatsListenerHandle.get());
    }

    public synchronized void disconnect() {
        if (this.roomState != RoomState.DISCONNECTED && this.nativeRoomContext != 0L) {
            this.nativeDisconnect(this.nativeRoomContext);
        }
    }

    long getListenerNativeHandle() {
        return this.internalRoomListenerHandle.get();
    }

    void setNativeContext(long nativeRoomHandle) {
        this.nativeRoomContext = nativeRoomHandle;
    }

    void onNetworkChanged(VideoClient.NetworkChangeEvent networkChangeEvent) {
        if (this.nativeRoomContext != 0L) {
            this.nativeOnNetworkChange(this.nativeRoomContext, networkChangeEvent);
        }
    }

    Object getConnectLock() {
        return this.internalRoomListenerImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void connect(Context context, ConnectOptions connectOptions) {
        InternalRoomListenerImpl internalRoomListenerImpl = this.internalRoomListenerImpl;
        synchronized (internalRoomListenerImpl) {
            this.nativeRoomContext = this.nativeConnect(connectOptions, MediaFactory.instance(context).getNativeMediaFactoryHandle(), this.internalRoomListenerHandle.get());
            this.roomState = RoomState.CONNECTING;
        }
    }

    synchronized void release() {
        if (this.nativeRoomContext != 0L) {
            for (Participant participant : this.participantMap.values()) {
                participant.release();
            }
            this.nativeRelease(this.nativeRoomContext);
            this.nativeRoomContext = 0L;
            this.internalRoomListenerHandle.release();
            this.internalRoomListenerHandle = null;
            if (this.internalStatsListenerHandle != null) {
                this.internalStatsListenerHandle.release();
                this.internalStatsListenerHandle = null;
            }
            this.cleanupStatsListenerQueue();
        }
    }

    private void cleanupStatsListenerQueue() {
        for (final Pair pair : this.statsListenersQueue) {
            ((Handler)pair.first).post(new Runnable(){

                @Override
                public void run() {
                    ((StatsListener)pair.second).onStats(new ArrayList<StatsReport>());
                }
            });
        }
        this.statsListenersQueue.clear();
    }

    void setState(RoomState roomState) {
        this.roomState = roomState;
    }

    private native long nativeConnect(ConnectOptions var1, long var2, long var4);

    private native boolean nativeIsRecording(long var1);

    private native void nativeDisconnect(long var1);

    private native void nativeGetStats(long var1, long var3);

    private native void nativeRelease(long var1);

    private native void nativeOnNetworkChange(long var1, VideoClient.NetworkChangeEvent var3);

    class InternalStatsListenerHandle
    extends NativeHandle {
        public InternalStatsListenerHandle(InternalStatsListener listener) {
            super(listener);
        }

        @Override
        protected native long nativeCreate(Object var1);

        @Override
        protected native void nativeRelease(long var1);
    }

    class InternalStatsListenerImpl
    implements InternalStatsListener {
        InternalStatsListenerImpl() {
        }

        @Override
        public void onStats(final List<StatsReport> statsReports) {
            final Pair statsPair = (Pair)Room.this.statsListenersQueue.poll();
            if (statsPair != null) {
                ((Handler)statsPair.first).post(new Runnable(){

                    @Override
                    public void run() {
                        ((StatsListener)statsPair.second).onStats(statsReports);
                    }
                });
            }
        }
    }

    static interface InternalStatsListener {
        public void onStats(List<StatsReport> var1);
    }

    class InternalRoomListenerHandle
    extends NativeHandle {
        InternalRoomListenerHandle(InternalRoomListener listener) {
            super(listener);
        }

        @Override
        protected native long nativeCreate(Object var1);

        @Override
        protected native void nativeRelease(long var1);
    }

    public static interface Listener {
        public void onConnected(Room var1);

        public void onConnectFailure(Room var1, TwilioException var2);

        public void onDisconnected(Room var1, TwilioException var2);

        public void onParticipantConnected(Room var1, Participant var2);

        public void onParticipantDisconnected(Room var1, Participant var2);

        public void onRecordingStarted(Room var1);

        public void onRecordingStopped(Room var1);
    }

    class InternalRoomListenerImpl
    implements InternalRoomListener {
        InternalRoomListenerImpl() {
        }

        Handler getHandler() {
            return Room.this.handler;
        }

        @Override
        public synchronized void onConnected(String roomSid, String localParticipantSid, String localParticipantIdentity, List<Participant> participantList) {
            logger.d("onConnected()");
            Room.this.sid = roomSid;
            if (Room.this.name == null || Room.this.name.isEmpty()) {
                Room.this.name = roomSid;
            }
            Room.this.localParticipant = new LocalParticipant(localParticipantSid, localParticipantIdentity, Room.this.localMedia);
            for (Participant participant : participantList) {
                Room.this.participantMap.put(participant.getSid(), participant);
            }
            Room.this.roomState = RoomState.CONNECTED;
            Room.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    Room.this.listener.onConnected(Room.this);
                }
            });
        }

        @Override
        public synchronized void onDisconnected(final TwilioException twilioException) {
            logger.d("onDisconnected()");
            Room.this.release();
            Room.this.roomState = RoomState.DISCONNECTED;
            Room.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    Room.this.listener.onDisconnected(Room.this, twilioException);
                }
            });
        }

        @Override
        public synchronized void onConnectFailure(final TwilioException twilioException) {
            logger.d("onConnectFailure()");
            Room.this.roomState = RoomState.DISCONNECTED;
            Room.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    Room.this.listener.onConnectFailure(Room.this, twilioException);
                }
            });
        }

        @Override
        public synchronized void onParticipantConnected(final Participant participant) {
            logger.d("onParticipantConnected()");
            Room.this.participantMap.put(participant.getSid(), participant);
            Room.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    Room.this.listener.onParticipantConnected(Room.this, participant);
                }
            });
        }

        @Override
        public synchronized void onParticipantDisconnected(String participantSid) {
            logger.d("onParticipantDisconnected()");
            final Participant participant = (Participant)Room.this.participantMap.remove(participantSid);
            if (participant == null) {
                logger.w("Received participant disconnected callback for non-existent participant");
                return;
            }
            participant.release();
            Room.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    Room.this.listener.onParticipantDisconnected(Room.this, participant);
                }
            });
        }

        @Override
        public void onRecordingStarted() {
            logger.d("onRecordingStarted()");
            Room.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    Room.this.listener.onRecordingStarted(Room.this);
                }
            });
        }

        @Override
        public void onRecordingStopped() {
            logger.d("onRecordingStopped()");
            Room.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    Room.this.listener.onRecordingStopped(Room.this);
                }
            });
        }
    }

    static interface InternalRoomListener {
        public void onConnected(String var1, String var2, String var3, List<Participant> var4);

        public void onDisconnected(TwilioException var1);

        public void onConnectFailure(TwilioException var1);

        public void onParticipantConnected(Participant var1);

        public void onParticipantDisconnected(String var1);

        public void onRecordingStarted();

        public void onRecordingStopped();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Error {
    }
}

