/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.taskrouter;

import com.twilio.taskrouter.Policy;
import com.twilio.taskrouter.TaskRouterCapability;

public class TaskRouterWorkerCapability
extends TaskRouterCapability {
    private final String tasksUrl;
    private final String activityUrl;
    private final String workerReservationsUrl;

    public TaskRouterWorkerCapability(String accountSid, String authToken, String workspaceSid, String workerSid) {
        super(accountSid, authToken, workspaceSid, workerSid);
        this.tasksUrl = this.baseUrl + "/Tasks/**";
        this.activityUrl = this.baseUrl + "/Activities";
        this.workerReservationsUrl = this.resourceUrl + "/Reservations/**";
        this.allow(this.activityUrl, "GET", null, null);
        this.allow(this.tasksUrl, "GET", null, null);
        this.allow(this.workerReservationsUrl, "GET", null, null);
    }

    @Override
    protected void setupResource() {
        this.resourceUrl = this.baseUrl + "/Workers/" + this.channelId;
    }

    public void allowActivityUpdates() {
        this.policies.add(new Policy(this.resourceUrl, "POST", true));
    }

    public void allowReservationUpdates() {
        this.policies.add(new Policy(this.tasksUrl, "POST", true));
        this.policies.add(new Policy(this.workerReservationsUrl, "POST", true));
    }
}

