/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.updater.taskrouter.v1;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.taskrouter.v1.Workspace;
import com.twilio.sdk.updater.Updater;

public class WorkspaceUpdater
extends Updater<Workspace> {
    private final String sid;
    private String defaultActivitySid;
    private String eventCallbackUrl;
    private String friendlyName;
    private String timeoutActivitySid;

    public WorkspaceUpdater(String sid) {
        this.sid = sid;
    }

    public WorkspaceUpdater setDefaultActivitySid(String defaultActivitySid) {
        this.defaultActivitySid = defaultActivitySid;
        return this;
    }

    public WorkspaceUpdater setEventCallbackUrl(String eventCallbackUrl) {
        this.eventCallbackUrl = eventCallbackUrl;
        return this;
    }

    public WorkspaceUpdater setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public WorkspaceUpdater setTimeoutActivitySid(String timeoutActivitySid) {
        this.timeoutActivitySid = timeoutActivitySid;
        return this;
    }

    @Override
    public Workspace execute(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, TwilioRestClient.Domains.TASKROUTER, "/v1/Workspaces/" + this.sid + "", client.getAccountSid());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Workspace update failed: Unable to connect to server");
        }
        if (response.getStatusCode() != 200) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Workspace.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.defaultActivitySid != null) {
            request.addPostParam("DefaultActivitySid", this.defaultActivitySid);
        }
        if (this.eventCallbackUrl != null) {
            request.addPostParam("EventCallbackUrl", this.eventCallbackUrl);
        }
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.timeoutActivitySid != null) {
            request.addPostParam("TimeoutActivitySid", this.timeoutActivitySid);
        }
    }
}

