/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.trunking.v1.trunk;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.sdk.converter.DateConverter;
import com.twilio.sdk.creator.trunking.v1.trunk.PhoneNumberCreator;
import com.twilio.sdk.deleter.trunking.v1.trunk.PhoneNumberDeleter;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.fetcher.trunking.v1.trunk.PhoneNumberFetcher;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.reader.trunking.v1.trunk.PhoneNumberReader;
import com.twilio.sdk.resource.SidResource;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PhoneNumber
extends SidResource {
    private static final long serialVersionUID = 99734519858175L;
    private final String accountSid;
    private final AddressRequirement addressRequirements;
    private final String apiVersion;
    private final Boolean beta;
    private final Map<String, String> capabilities;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final String friendlyName;
    private final Map<String, String> links;
    private final com.twilio.sdk.type.PhoneNumber phoneNumber;
    private final String sid;
    private final String smsApplicationSid;
    private final HttpMethod smsFallbackMethod;
    private final URI smsFallbackUrl;
    private final HttpMethod smsMethod;
    private final URI smsUrl;
    private final URI statusCallback;
    private final HttpMethod statusCallbackMethod;
    private final String trunkSid;
    private final URI url;
    private final String voiceApplicationSid;
    private final Boolean voiceCallerIdLookup;
    private final HttpMethod voiceFallbackMethod;
    private final URI voiceFallbackUrl;
    private final HttpMethod voiceMethod;
    private final URI voiceUrl;

    public static PhoneNumberFetcher fetch(String trunkSid, String sid) {
        return new PhoneNumberFetcher(trunkSid, sid);
    }

    public static PhoneNumberDeleter delete(String trunkSid, String sid) {
        return new PhoneNumberDeleter(trunkSid, sid);
    }

    public static PhoneNumberCreator create(String trunkSid, String phoneNumberSid) {
        return new PhoneNumberCreator(trunkSid, phoneNumberSid);
    }

    public static PhoneNumberReader read(String trunkSid) {
        return new PhoneNumberReader(trunkSid);
    }

    public static PhoneNumber fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (PhoneNumber)objectMapper.readValue(json, PhoneNumber.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static PhoneNumber fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (PhoneNumber)objectMapper.readValue(json, PhoneNumber.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private PhoneNumber(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="address_requirements") AddressRequirement addressRequirements, @JsonProperty(value="api_version") String apiVersion, @JsonProperty(value="beta") Boolean beta, @JsonProperty(value="capabilities") Map<String, String> capabilities, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="links") Map<String, String> links, @JsonProperty(value="phone_number") com.twilio.sdk.type.PhoneNumber phoneNumber, @JsonProperty(value="sid") String sid, @JsonProperty(value="sms_application_sid") String smsApplicationSid, @JsonProperty(value="sms_fallback_method") HttpMethod smsFallbackMethod, @JsonProperty(value="sms_fallback_url") URI smsFallbackUrl, @JsonProperty(value="sms_method") HttpMethod smsMethod, @JsonProperty(value="sms_url") URI smsUrl, @JsonProperty(value="status_callback") URI statusCallback, @JsonProperty(value="status_callback_method") HttpMethod statusCallbackMethod, @JsonProperty(value="trunk_sid") String trunkSid, @JsonProperty(value="url") URI url, @JsonProperty(value="voice_application_sid") String voiceApplicationSid, @JsonProperty(value="voice_caller_id_lookup") Boolean voiceCallerIdLookup, @JsonProperty(value="voice_fallback_method") HttpMethod voiceFallbackMethod, @JsonProperty(value="voice_fallback_url") URI voiceFallbackUrl, @JsonProperty(value="voice_method") HttpMethod voiceMethod, @JsonProperty(value="voice_url") URI voiceUrl) {
        this.accountSid = accountSid;
        this.addressRequirements = addressRequirements;
        this.apiVersion = apiVersion;
        this.beta = beta;
        this.capabilities = capabilities;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.friendlyName = friendlyName;
        this.links = links;
        this.phoneNumber = phoneNumber;
        this.sid = sid;
        this.smsApplicationSid = smsApplicationSid;
        this.smsFallbackMethod = smsFallbackMethod;
        this.smsFallbackUrl = smsFallbackUrl;
        this.smsMethod = smsMethod;
        this.smsUrl = smsUrl;
        this.statusCallback = statusCallback;
        this.statusCallbackMethod = statusCallbackMethod;
        this.trunkSid = trunkSid;
        this.url = url;
        this.voiceApplicationSid = voiceApplicationSid;
        this.voiceCallerIdLookup = voiceCallerIdLookup;
        this.voiceFallbackMethod = voiceFallbackMethod;
        this.voiceFallbackUrl = voiceFallbackUrl;
        this.voiceMethod = voiceMethod;
        this.voiceUrl = voiceUrl;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final AddressRequirement getAddressRequirements() {
        return this.addressRequirements;
    }

    public final String getApiVersion() {
        return this.apiVersion;
    }

    public final Boolean getBeta() {
        return this.beta;
    }

    public final Map<String, String> getCapabilities() {
        return this.capabilities;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public final com.twilio.sdk.type.PhoneNumber getPhoneNumber() {
        return this.phoneNumber;
    }

    @Override
    public final String getSid() {
        return this.sid;
    }

    public final String getSmsApplicationSid() {
        return this.smsApplicationSid;
    }

    public final HttpMethod getSmsFallbackMethod() {
        return this.smsFallbackMethod;
    }

    public final URI getSmsFallbackUrl() {
        return this.smsFallbackUrl;
    }

    public final HttpMethod getSmsMethod() {
        return this.smsMethod;
    }

    public final URI getSmsUrl() {
        return this.smsUrl;
    }

    public final URI getStatusCallback() {
        return this.statusCallback;
    }

    public final HttpMethod getStatusCallbackMethod() {
        return this.statusCallbackMethod;
    }

    public final String getTrunkSid() {
        return this.trunkSid;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final String getVoiceApplicationSid() {
        return this.voiceApplicationSid;
    }

    public final Boolean getVoiceCallerIdLookup() {
        return this.voiceCallerIdLookup;
    }

    public final HttpMethod getVoiceFallbackMethod() {
        return this.voiceFallbackMethod;
    }

    public final URI getVoiceFallbackUrl() {
        return this.voiceFallbackUrl;
    }

    public final HttpMethod getVoiceMethod() {
        return this.voiceMethod;
    }

    public final URI getVoiceUrl() {
        return this.voiceUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PhoneNumber other = (PhoneNumber)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals((Object)this.addressRequirements, (Object)other.addressRequirements) && Objects.equals(this.apiVersion, other.apiVersion) && Objects.equals(this.beta, other.beta) && Objects.equals(this.capabilities, other.capabilities) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.links, other.links) && Objects.equals(this.phoneNumber, other.phoneNumber) && Objects.equals(this.sid, other.sid) && Objects.equals(this.smsApplicationSid, other.smsApplicationSid) && Objects.equals((Object)this.smsFallbackMethod, (Object)other.smsFallbackMethod) && Objects.equals(this.smsFallbackUrl, other.smsFallbackUrl) && Objects.equals((Object)this.smsMethod, (Object)other.smsMethod) && Objects.equals(this.smsUrl, other.smsUrl) && Objects.equals(this.statusCallback, other.statusCallback) && Objects.equals((Object)this.statusCallbackMethod, (Object)other.statusCallbackMethod) && Objects.equals(this.trunkSid, other.trunkSid) && Objects.equals(this.url, other.url) && Objects.equals(this.voiceApplicationSid, other.voiceApplicationSid) && Objects.equals(this.voiceCallerIdLookup, other.voiceCallerIdLookup) && Objects.equals((Object)this.voiceFallbackMethod, (Object)other.voiceFallbackMethod) && Objects.equals(this.voiceFallbackUrl, other.voiceFallbackUrl) && Objects.equals((Object)this.voiceMethod, (Object)other.voiceMethod) && Objects.equals(this.voiceUrl, other.voiceUrl);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountSid, this.addressRequirements, this.apiVersion, this.beta, this.capabilities, this.dateCreated, this.dateUpdated, this.friendlyName, this.links, this.phoneNumber, this.sid, this.smsApplicationSid, this.smsFallbackMethod, this.smsFallbackUrl, this.smsMethod, this.smsUrl, this.statusCallback, this.statusCallbackMethod, this.trunkSid, this.url, this.voiceApplicationSid, this.voiceCallerIdLookup, this.voiceFallbackMethod, this.voiceFallbackUrl, this.voiceMethod, this.voiceUrl});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("accountSid", (Object)this.accountSid).add("addressRequirements", (Object)this.addressRequirements).add("apiVersion", (Object)this.apiVersion).add("beta", (Object)this.beta).add("capabilities", this.capabilities).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("friendlyName", (Object)this.friendlyName).add("links", this.links).add("phoneNumber", (Object)this.phoneNumber).add("sid", (Object)this.sid).add("smsApplicationSid", (Object)this.smsApplicationSid).add("smsFallbackMethod", (Object)this.smsFallbackMethod).add("smsFallbackUrl", (Object)this.smsFallbackUrl).add("smsMethod", (Object)this.smsMethod).add("smsUrl", (Object)this.smsUrl).add("statusCallback", (Object)this.statusCallback).add("statusCallbackMethod", (Object)this.statusCallbackMethod).add("trunkSid", (Object)this.trunkSid).add("url", (Object)this.url).add("voiceApplicationSid", (Object)this.voiceApplicationSid).add("voiceCallerIdLookup", (Object)this.voiceCallerIdLookup).add("voiceFallbackMethod", (Object)this.voiceFallbackMethod).add("voiceFallbackUrl", (Object)this.voiceFallbackUrl).add("voiceMethod", (Object)this.voiceMethod).add("voiceUrl", (Object)this.voiceUrl).toString();
    }

    public static enum AddressRequirement {
        NONE("none"),
        ANY("any"),
        LOCAL("local"),
        FOREIGN("foreign");

        private final String value;

        private AddressRequirement(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static AddressRequirement forValue(String value) {
            String normalized = value.replace("-", "_").toUpperCase();
            try {
                return AddressRequirement.valueOf(normalized);
            }
            catch (RuntimeException e) {
                return null;
            }
        }
    }
}

