/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.ipmessaging.v1.service.channel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.sdk.converter.DateConverter;
import com.twilio.sdk.creator.ipmessaging.v1.service.channel.MemberCreator;
import com.twilio.sdk.deleter.ipmessaging.v1.service.channel.MemberDeleter;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.fetcher.ipmessaging.v1.service.channel.MemberFetcher;
import com.twilio.sdk.reader.ipmessaging.v1.service.channel.MemberReader;
import com.twilio.sdk.resource.SidResource;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Member
extends SidResource {
    private static final long serialVersionUID = 56143758683259L;
    private final String sid;
    private final String accountSid;
    private final String channelSid;
    private final String serviceSid;
    private final String identity;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final String roleSid;
    private final URI url;

    public static MemberFetcher fetch(String serviceSid, String channelSid, String sid) {
        return new MemberFetcher(serviceSid, channelSid, sid);
    }

    public static MemberCreator create(String serviceSid, String channelSid, String identity) {
        return new MemberCreator(serviceSid, channelSid, identity);
    }

    public static MemberReader read(String serviceSid, String channelSid) {
        return new MemberReader(serviceSid, channelSid);
    }

    public static MemberDeleter delete(String serviceSid, String channelSid, String sid) {
        return new MemberDeleter(serviceSid, channelSid, sid);
    }

    public static Member fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (Member)objectMapper.readValue(json, Member.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Member fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (Member)objectMapper.readValue(json, Member.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Member(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="channel_sid") String channelSid, @JsonProperty(value="service_sid") String serviceSid, @JsonProperty(value="identity") String identity, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="role_sid") String roleSid, @JsonProperty(value="url") URI url) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.channelSid = channelSid;
        this.serviceSid = serviceSid;
        this.identity = identity;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.roleSid = roleSid;
        this.url = url;
    }

    @Override
    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getChannelSid() {
        return this.channelSid;
    }

    public final String getServiceSid() {
        return this.serviceSid;
    }

    public final String getIdentity() {
        return this.identity;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getRoleSid() {
        return this.roleSid;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Member other = (Member)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.channelSid, other.channelSid) && Objects.equals(this.serviceSid, other.serviceSid) && Objects.equals(this.identity, other.identity) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.roleSid, other.roleSid) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.accountSid, this.channelSid, this.serviceSid, this.identity, this.dateCreated, this.dateUpdated, this.roleSid, this.url);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sid", (Object)this.sid).add("accountSid", (Object)this.accountSid).add("channelSid", (Object)this.channelSid).add("serviceSid", (Object)this.serviceSid).add("identity", (Object)this.identity).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("roleSid", (Object)this.roleSid).add("url", (Object)this.url).toString();
    }
}

