/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.reader.taskrouter.v1.workspace;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.reader.Reader;
import com.twilio.sdk.resource.Page;
import com.twilio.sdk.resource.ResourceSet;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.taskrouter.v1.workspace.Task;

public class TaskReader
extends Reader<Task> {
    private final String workspaceSid;
    private Integer priority;
    private Task.Status assignmentStatus;
    private String workflowSid;
    private String workflowName;
    private String taskQueueSid;
    private String taskQueueName;

    public TaskReader(String workspaceSid) {
        this.workspaceSid = workspaceSid;
    }

    public TaskReader byPriority(Integer priority) {
        this.priority = priority;
        return this;
    }

    public TaskReader byAssignmentStatus(Task.Status assignmentStatus) {
        this.assignmentStatus = assignmentStatus;
        return this;
    }

    public TaskReader byWorkflowSid(String workflowSid) {
        this.workflowSid = workflowSid;
        return this;
    }

    public TaskReader byWorkflowName(String workflowName) {
        this.workflowName = workflowName;
        return this;
    }

    public TaskReader byTaskQueueSid(String taskQueueSid) {
        this.taskQueueSid = taskQueueSid;
        return this;
    }

    public TaskReader byTaskQueueName(String taskQueueName) {
        this.taskQueueName = taskQueueName;
        return this;
    }

    @Override
    public ResourceSet<Task> execute(TwilioRestClient client) {
        return new ResourceSet<Task>(this, client, this.firstPage());
    }

    @Override
    public Page<Task> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, TwilioRestClient.Domains.TASKROUTER, "/v1/Workspaces/" + this.workspaceSid + "/Tasks", client.getAccountSid());
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Task> nextPage(Page<Task> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUri(), client.getAccountSid());
        return this.pageForRequest(client, request);
    }

    private Page<Task> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Task read failed: Unable to connect to server");
        }
        if (response.getStatusCode() != 200) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Page.fromJson("tasks", response.getContent(), Task.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.priority != null) {
            request.addQueryParam("Priority", this.priority.toString());
        }
        if (this.assignmentStatus != null) {
            request.addQueryParam("AssignmentStatus", this.assignmentStatus.toString());
        }
        if (this.workflowSid != null) {
            request.addQueryParam("WorkflowSid", this.workflowSid);
        }
        if (this.workflowName != null) {
            request.addQueryParam("WorkflowName", this.workflowName);
        }
        if (this.taskQueueSid != null) {
            request.addQueryParam("TaskQueueSid", this.taskQueueSid);
        }
        if (this.taskQueueName != null) {
            request.addQueryParam("TaskQueueName", this.taskQueueName);
        }
        request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
    }
}

