/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.reader.api.v2010.account;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.reader.Reader;
import com.twilio.sdk.resource.Page;
import com.twilio.sdk.resource.ResourceSet;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.api.v2010.account.OutgoingCallerId;
import com.twilio.sdk.type.PhoneNumber;

public class OutgoingCallerIdReader
extends Reader<OutgoingCallerId> {
    private final String accountSid;
    private PhoneNumber phoneNumber;
    private String friendlyName;

    public OutgoingCallerIdReader(String accountSid) {
        this.accountSid = accountSid;
    }

    public OutgoingCallerIdReader byPhoneNumber(PhoneNumber phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    public OutgoingCallerIdReader byFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    @Override
    public ResourceSet<OutgoingCallerId> execute(TwilioRestClient client) {
        return new ResourceSet<OutgoingCallerId>(this, client, this.firstPage());
    }

    @Override
    public Page<OutgoingCallerId> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, TwilioRestClient.Domains.API, "/2010-04-01/Accounts/" + this.accountSid + "/OutgoingCallerIds.json", client.getAccountSid());
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<OutgoingCallerId> nextPage(Page<OutgoingCallerId> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUri(), client.getAccountSid());
        return this.pageForRequest(client, request);
    }

    private Page<OutgoingCallerId> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("OutgoingCallerId read failed: Unable to connect to server");
        }
        if (response.getStatusCode() != 200) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Page.fromJson("outgoing_caller_ids", response.getContent(), OutgoingCallerId.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.phoneNumber != null) {
            request.addQueryParam("PhoneNumber", this.phoneNumber.toString());
        }
        if (this.friendlyName != null) {
            request.addQueryParam("FriendlyName", this.friendlyName);
        }
        request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
    }
}

