/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /       
 */

package com.twilio.sdk.reader.taskrouter.v1.workspace.taskqueue;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.converter.DateConverter;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.reader.Reader;
import com.twilio.sdk.resource.Page;
import com.twilio.sdk.resource.ResourceSet;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.taskrouter.v1.workspace.taskqueue.TaskQueuesStatistics;
import org.joda.time.DateTime;

public class TaskQueuesStatisticsReader extends Reader<TaskQueuesStatistics> {
    private final String workspaceSid;
    private DateTime endDate;
    private String friendlyName;
    private Integer minutes;
    private DateTime startDate;

    /**
     * Construct a new TaskQueuesStatisticsReader.
     * 
     * @param workspaceSid The workspace_sid
     */
    public TaskQueuesStatisticsReader(final String workspaceSid) {
        this.workspaceSid = workspaceSid;
    }

    /**
     * The end_date.
     * 
     * @param endDate The end_date
     * @return this
     */
    public TaskQueuesStatisticsReader byEndDate(final DateTime endDate) {
        this.endDate = endDate;
        return this;
    }

    /**
     * The friendly_name.
     * 
     * @param friendlyName The friendly_name
     * @return this
     */
    public TaskQueuesStatisticsReader byFriendlyName(final String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    /**
     * The minutes.
     * 
     * @param minutes The minutes
     * @return this
     */
    public TaskQueuesStatisticsReader byMinutes(final Integer minutes) {
        this.minutes = minutes;
        return this;
    }

    /**
     * The start_date.
     * 
     * @param startDate The start_date
     * @return this
     */
    public TaskQueuesStatisticsReader byStartDate(final DateTime startDate) {
        this.startDate = startDate;
        return this;
    }

    /**
     * Make the request to the Twilio API to perform the read.
     * 
     * @param client TwilioRestClient with which to make the request
     * @return TaskQueuesStatistics ResourceSet
     */
    @Override
    public ResourceSet<TaskQueuesStatistics> execute(final TwilioRestClient client) {
        return new ResourceSet<>(this, client, firstPage());
    }

    /**
     * Make the request to the Twilio API to perform the read.
     * 
     * @param client TwilioRestClient with which to make the request
     * @return TaskQueuesStatistics ResourceSet
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public Page<TaskQueuesStatistics> firstPage(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.GET,
            TwilioRestClient.Domains.TASKROUTER,
            "/v1/Workspaces/" + this.workspaceSid + "/TaskQueues/Statistics",
            client.getAccountSid()
        );
        
        addQueryParams(request);
        return pageForRequest(client, request);
    }

    /**
     * Retrieve the next page from the Twilio API.
     * 
     * @param page current page
     * @param client TwilioRestClient with which to make the request
     * @return Next Page
     */
    @Override
    public Page<TaskQueuesStatistics> nextPage(final Page<TaskQueuesStatistics> page, 
                                               final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.GET,
            page.getNextPageUri(),
            client.getAccountSid()
        );
        return pageForRequest(client, request);
    }

    /**
     * Generate a Page of TaskQueuesStatistics Resources for a given request.
     * 
     * @param client TwilioRestClient with which to make the request
     * @param request Request to generate a page for
     * @return Page for the Request
     */
    private Page<TaskQueuesStatistics> pageForRequest(final TwilioRestClient client, final Request request) {
        Response response = client.request(request);
        
        if (response == null) {
            throw new ApiConnectionException("TaskQueuesStatistics read failed: Unable to connect to server");
        } else if (response.getStatusCode() != TwilioRestClient.HTTP_STATUS_CODE_OK) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
        
            throw new ApiException(
                restException.getMessage(),
                restException.getCode(),
                restException.getMoreInfo(),
                restException.getStatus(),
                null
            );
        }
        
        return Page.fromJson(
            "task_queues_statistics",
            response.getContent(),
            TaskQueuesStatistics.class,
            client.getObjectMapper()
        );
    }

    /**
     * Add the requested query string arguments to the Request.
     * 
     * @param request Request to add query string arguments to
     */
    private void addQueryParams(final Request request) {
        if (endDate != null) {
            request.addQueryParam("EndDate", endDate.toString());
        }
        
        if (friendlyName != null) {
            request.addQueryParam("FriendlyName", friendlyName);
        }
        
        if (minutes != null) {
            request.addQueryParam("Minutes", minutes.toString());
        }
        
        if (startDate != null) {
            request.addQueryParam("StartDate", startDate.toString());
        }
        
        request.addQueryParam("PageSize", Integer.toString(getPageSize()));
    }
}