/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.updater.notifications.v1;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.notifications.v1.Credential;
import com.twilio.sdk.updater.Updater;

public class CredentialUpdater
extends Updater<Credential> {
    private final String sid;
    private final String friendlyName;
    private final Credential.PushService type;
    private String certificate;
    private String privateKey;
    private Boolean sandbox;
    private String apiKey;

    public CredentialUpdater(String sid, String friendlyName, Credential.PushService type) {
        this.sid = sid;
        this.friendlyName = friendlyName;
        this.type = type;
    }

    public CredentialUpdater setCertificate(String certificate) {
        this.certificate = certificate;
        return this;
    }

    public CredentialUpdater setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
        return this;
    }

    public CredentialUpdater setSandbox(Boolean sandbox) {
        this.sandbox = sandbox;
        return this;
    }

    public CredentialUpdater setApiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    @Override
    public Credential execute(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, TwilioRestClient.Domains.NOTIFICATIONS, "/v1/Credentials/" + this.sid + "", client.getAccountSid());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Credential update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Credential.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.type != null) {
            request.addPostParam("Type", this.type.toString());
        }
        if (this.certificate != null) {
            request.addPostParam("Certificate", this.certificate);
        }
        if (this.privateKey != null) {
            request.addPostParam("PrivateKey", this.privateKey);
        }
        if (this.sandbox != null) {
            request.addPostParam("Sandbox", this.sandbox.toString());
        }
        if (this.apiKey != null) {
            request.addPostParam("ApiKey", this.apiKey);
        }
    }
}

