/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.updater.api.v2010.account.sip.credentiallist;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.api.v2010.account.sip.credentiallist.Credential;
import com.twilio.sdk.updater.Updater;

public class CredentialUpdater
extends Updater<Credential> {
    private final String accountSid;
    private final String credentialListSid;
    private final String sid;
    private final String username;
    private final String password;

    public CredentialUpdater(String accountSid, String credentialListSid, String sid, String username, String password) {
        this.accountSid = accountSid;
        this.credentialListSid = credentialListSid;
        this.sid = sid;
        this.username = username;
        this.password = password;
    }

    @Override
    public Credential execute(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, TwilioRestClient.Domains.API, "/2010-04-01/Accounts/" + this.accountSid + "/SIP/CredentialLists/" + this.credentialListSid + "/Credentials/" + this.sid + ".json", client.getAccountSid());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Credential update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Credential.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.username != null) {
            request.addPostParam("Username", this.username);
        }
        if (this.password != null) {
            request.addPostParam("Password", this.password);
        }
    }
}

