/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.updater.api.v2010.account.call;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.converter.Promoter;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.api.v2010.account.call.Feedback;
import com.twilio.sdk.updater.Updater;
import java.util.List;

public class FeedbackUpdater
extends Updater<Feedback> {
    private final String accountSid;
    private final String callSid;
    private final Integer qualityScore;
    private List<Feedback.Issues> issue;

    public FeedbackUpdater(String accountSid, String callSid, Integer qualityScore) {
        this.accountSid = accountSid;
        this.callSid = callSid;
        this.qualityScore = qualityScore;
    }

    public FeedbackUpdater setIssue(List<Feedback.Issues> issue) {
        this.issue = issue;
        return this;
    }

    public FeedbackUpdater setIssue(Feedback.Issues issue) {
        return this.setIssue(Promoter.listOfOne(issue));
    }

    @Override
    public Feedback execute(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, TwilioRestClient.Domains.API, "/2010-04-01/Accounts/" + this.accountSid + "/Calls/" + this.callSid + "/Feedback.json", client.getAccountSid());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Feedback update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Feedback.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.qualityScore != null) {
            request.addPostParam("QualityScore", this.qualityScore.toString());
        }
        if (this.issue != null) {
            for (Feedback.Issues prop : this.issue) {
                request.addPostParam("Issue", ((Object)((Object)prop)).toString());
            }
        }
    }
}

