/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.conversations.v1.conversation;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.sdk.converter.DateConverter;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.reader.conversations.v1.conversation.CompletedReader;
import com.twilio.sdk.resource.Resource;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Completed
extends Resource {
    private static final long serialVersionUID = 33453296983711L;
    private final String sid;
    private final Status status;
    private final Integer duration;
    private final DateTime dateCreated;
    private final DateTime startTime;
    private final DateTime endTime;
    private final String accountSid;
    private final URI url;

    public static CompletedReader read() {
        return new CompletedReader();
    }

    public static Completed fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (Completed)objectMapper.readValue(json, Completed.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Completed fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (Completed)objectMapper.readValue(json, Completed.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Completed(@JsonProperty(value="sid") String sid, @JsonProperty(value="status") Status status, @JsonProperty(value="duration") Integer duration, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="start_time") String startTime, @JsonProperty(value="end_time") String endTime, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="url") URI url) {
        this.sid = sid;
        this.status = status;
        this.duration = duration;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.startTime = DateConverter.iso8601DateTimeFromString(startTime);
        this.endTime = DateConverter.iso8601DateTimeFromString(endTime);
        this.accountSid = accountSid;
        this.url = url;
    }

    public final String getSid() {
        return this.sid;
    }

    public final Status getStatus() {
        return this.status;
    }

    public final Integer getDuration() {
        return this.duration;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getStartTime() {
        return this.startTime;
    }

    public final DateTime getEndTime() {
        return this.endTime;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Completed other = (Completed)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.duration, other.duration) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.startTime, other.startTime) && Objects.equals(this.endTime, other.endTime) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sid, this.status, this.duration, this.dateCreated, this.startTime, this.endTime, this.accountSid, this.url});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sid", (Object)this.sid).add("status", (Object)this.status).add("duration", (Object)this.duration).add("dateCreated", (Object)this.dateCreated).add("startTime", (Object)this.startTime).add("endTime", (Object)this.endTime).add("accountSid", (Object)this.accountSid).add("url", (Object)this.url).toString();
    }

    public static enum Status {
        CREATED("created"),
        IN_PROGRESS("in-progress"),
        COMPLETED("completed"),
        FAILED("failed");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Status forValue(String value) {
            String normalized = value.replace("-", "_").toUpperCase();
            try {
                return Status.valueOf(normalized);
            }
            catch (RuntimeException e) {
                return null;
            }
        }
    }
}

