/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.api.v2010.account.sms;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.sdk.converter.DateConverter;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.fetcher.api.v2010.account.sms.ShortCodeFetcher;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.reader.api.v2010.account.sms.ShortCodeReader;
import com.twilio.sdk.resource.SidResource;
import com.twilio.sdk.updater.api.v2010.account.sms.ShortCodeUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ShortCode
extends SidResource {
    private static final long serialVersionUID = 186171326966142L;
    private final String accountSid;
    private final String apiVersion;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final String friendlyName;
    private final String shortCode;
    private final String sid;
    private final HttpMethod smsFallbackMethod;
    private final URI smsFallbackUrl;
    private final HttpMethod smsMethod;
    private final URI smsUrl;
    private final String uri;

    public static ShortCodeFetcher fetch(String accountSid, String sid) {
        return new ShortCodeFetcher(accountSid, sid);
    }

    public static ShortCodeUpdater update(String accountSid, String sid) {
        return new ShortCodeUpdater(accountSid, sid);
    }

    public static ShortCodeReader read(String accountSid) {
        return new ShortCodeReader(accountSid);
    }

    public static ShortCode fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (ShortCode)objectMapper.readValue(json, ShortCode.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static ShortCode fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (ShortCode)objectMapper.readValue(json, ShortCode.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private ShortCode(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="api_version") String apiVersion, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="short_code") String shortCode, @JsonProperty(value="sid") String sid, @JsonProperty(value="sms_fallback_method") HttpMethod smsFallbackMethod, @JsonProperty(value="sms_fallback_url") URI smsFallbackUrl, @JsonProperty(value="sms_method") HttpMethod smsMethod, @JsonProperty(value="sms_url") URI smsUrl, @JsonProperty(value="uri") String uri) {
        this.accountSid = accountSid;
        this.apiVersion = apiVersion;
        this.dateCreated = DateConverter.rfc2822DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.rfc2822DateTimeFromString(dateUpdated);
        this.friendlyName = friendlyName;
        this.shortCode = shortCode;
        this.sid = sid;
        this.smsFallbackMethod = smsFallbackMethod;
        this.smsFallbackUrl = smsFallbackUrl;
        this.smsMethod = smsMethod;
        this.smsUrl = smsUrl;
        this.uri = uri;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getApiVersion() {
        return this.apiVersion;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getShortCode() {
        return this.shortCode;
    }

    @Override
    public final String getSid() {
        return this.sid;
    }

    public final HttpMethod getSmsFallbackMethod() {
        return this.smsFallbackMethod;
    }

    public final URI getSmsFallbackUrl() {
        return this.smsFallbackUrl;
    }

    public final HttpMethod getSmsMethod() {
        return this.smsMethod;
    }

    public final URI getSmsUrl() {
        return this.smsUrl;
    }

    public final String getUri() {
        return this.uri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShortCode other = (ShortCode)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.apiVersion, other.apiVersion) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.shortCode, other.shortCode) && Objects.equals(this.sid, other.sid) && Objects.equals((Object)this.smsFallbackMethod, (Object)other.smsFallbackMethod) && Objects.equals(this.smsFallbackUrl, other.smsFallbackUrl) && Objects.equals((Object)this.smsMethod, (Object)other.smsMethod) && Objects.equals(this.smsUrl, other.smsUrl) && Objects.equals(this.uri, other.uri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountSid, this.apiVersion, this.dateCreated, this.dateUpdated, this.friendlyName, this.shortCode, this.sid, this.smsFallbackMethod, this.smsFallbackUrl, this.smsMethod, this.smsUrl, this.uri});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("accountSid", (Object)this.accountSid).add("apiVersion", (Object)this.apiVersion).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("friendlyName", (Object)this.friendlyName).add("shortCode", (Object)this.shortCode).add("sid", (Object)this.sid).add("smsFallbackMethod", (Object)this.smsFallbackMethod).add("smsFallbackUrl", (Object)this.smsFallbackUrl).add("smsMethod", (Object)this.smsMethod).add("smsUrl", (Object)this.smsUrl).add("uri", (Object)this.uri).toString();
    }
}

