/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.api.v2010.account;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.sdk.converter.DateConverter;
import com.twilio.sdk.creator.api.v2010.account.AddressCreator;
import com.twilio.sdk.deleter.api.v2010.account.AddressDeleter;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.fetcher.api.v2010.account.AddressFetcher;
import com.twilio.sdk.reader.api.v2010.account.AddressReader;
import com.twilio.sdk.resource.SidResource;
import com.twilio.sdk.updater.api.v2010.account.AddressUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Address
extends SidResource {
    private static final long serialVersionUID = 241863313934407L;
    private final String accountSid;
    private final String city;
    private final String customerName;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final String friendlyName;
    private final String isoCountry;
    private final String postalCode;
    private final String region;
    private final String sid;
    private final String street;
    private final String uri;

    public static AddressCreator create(String accountSid, String customerName, String street, String city, String region, String postalCode, String isoCountry) {
        return new AddressCreator(accountSid, customerName, street, city, region, postalCode, isoCountry);
    }

    public static AddressDeleter delete(String accountSid, String sid) {
        return new AddressDeleter(accountSid, sid);
    }

    public static AddressFetcher fetch(String accountSid, String sid) {
        return new AddressFetcher(accountSid, sid);
    }

    public static AddressUpdater update(String accountSid, String sid) {
        return new AddressUpdater(accountSid, sid);
    }

    public static AddressReader read(String accountSid) {
        return new AddressReader(accountSid);
    }

    public static Address fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (Address)objectMapper.readValue(json, Address.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Address fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (Address)objectMapper.readValue(json, Address.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Address(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="city") String city, @JsonProperty(value="customer_name") String customerName, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="iso_country") String isoCountry, @JsonProperty(value="postal_code") String postalCode, @JsonProperty(value="region") String region, @JsonProperty(value="sid") String sid, @JsonProperty(value="street") String street, @JsonProperty(value="uri") String uri) {
        this.accountSid = accountSid;
        this.city = city;
        this.customerName = customerName;
        this.dateCreated = DateConverter.rfc2822DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.rfc2822DateTimeFromString(dateUpdated);
        this.friendlyName = friendlyName;
        this.isoCountry = isoCountry;
        this.postalCode = postalCode;
        this.region = region;
        this.sid = sid;
        this.street = street;
        this.uri = uri;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getCity() {
        return this.city;
    }

    public final String getCustomerName() {
        return this.customerName;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getIsoCountry() {
        return this.isoCountry;
    }

    public final String getPostalCode() {
        return this.postalCode;
    }

    public final String getRegion() {
        return this.region;
    }

    @Override
    public final String getSid() {
        return this.sid;
    }

    public final String getStreet() {
        return this.street;
    }

    public final String getUri() {
        return this.uri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Address other = (Address)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.city, other.city) && Objects.equals(this.customerName, other.customerName) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.isoCountry, other.isoCountry) && Objects.equals(this.postalCode, other.postalCode) && Objects.equals(this.region, other.region) && Objects.equals(this.sid, other.sid) && Objects.equals(this.street, other.street) && Objects.equals(this.uri, other.uri);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.city, this.customerName, this.dateCreated, this.dateUpdated, this.friendlyName, this.isoCountry, this.postalCode, this.region, this.sid, this.street, this.uri);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("accountSid", (Object)this.accountSid).add("city", (Object)this.city).add("customerName", (Object)this.customerName).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("friendlyName", (Object)this.friendlyName).add("isoCountry", (Object)this.isoCountry).add("postalCode", (Object)this.postalCode).add("region", (Object)this.region).add("sid", (Object)this.sid).add("street", (Object)this.street).add("uri", (Object)this.uri).toString();
    }
}

