/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.reader.trunking.v1.trunk;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.reader.Reader;
import com.twilio.sdk.resource.Page;
import com.twilio.sdk.resource.ResourceSet;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.trunking.v1.trunk.CredentialList;

public class CredentialListReader
extends Reader<CredentialList> {
    private final String trunkSid;

    public CredentialListReader(String trunkSid) {
        this.trunkSid = trunkSid;
    }

    @Override
    public ResourceSet<CredentialList> execute(TwilioRestClient client) {
        return new ResourceSet<CredentialList>(this, client, this.firstPage());
    }

    @Override
    public Page<CredentialList> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, TwilioRestClient.Domains.TRUNKING, "/v1/Trunks/" + this.trunkSid + "/CredentialLists", client.getAccountSid());
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<CredentialList> nextPage(Page<CredentialList> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUri(), client.getAccountSid());
        return this.pageForRequest(client, request);
    }

    private Page<CredentialList> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("CredentialList read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Page.fromJson("credential_lists", response.getContent(), CredentialList.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
    }
}

