/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.reader.taskrouter.v1.workspace.taskqueue;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.reader.Reader;
import com.twilio.sdk.resource.Page;
import com.twilio.sdk.resource.ResourceSet;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.taskrouter.v1.workspace.taskqueue.TaskQueuesStatistics;
import org.joda.time.DateTime;

public class TaskQueuesStatisticsReader
extends Reader<TaskQueuesStatistics> {
    private final String workspaceSid;
    private DateTime endDate;
    private String friendlyName;
    private Integer minutes;
    private DateTime startDate;

    public TaskQueuesStatisticsReader(String workspaceSid) {
        this.workspaceSid = workspaceSid;
    }

    public TaskQueuesStatisticsReader byEndDate(DateTime endDate) {
        this.endDate = endDate;
        return this;
    }

    public TaskQueuesStatisticsReader byFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public TaskQueuesStatisticsReader byMinutes(Integer minutes) {
        this.minutes = minutes;
        return this;
    }

    public TaskQueuesStatisticsReader byStartDate(DateTime startDate) {
        this.startDate = startDate;
        return this;
    }

    @Override
    public ResourceSet<TaskQueuesStatistics> execute(TwilioRestClient client) {
        return new ResourceSet<TaskQueuesStatistics>(this, client, this.firstPage());
    }

    @Override
    public Page<TaskQueuesStatistics> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, TwilioRestClient.Domains.TASKROUTER, "/v1/Workspaces/" + this.workspaceSid + "/TaskQueues/Statistics", client.getAccountSid());
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<TaskQueuesStatistics> nextPage(Page<TaskQueuesStatistics> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUri(), client.getAccountSid());
        return this.pageForRequest(client, request);
    }

    private Page<TaskQueuesStatistics> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("TaskQueuesStatistics read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Page.fromJson("task_queues_statistics", response.getContent(), TaskQueuesStatistics.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.endDate != null) {
            request.addQueryParam("EndDate", this.endDate.toString());
        }
        if (this.friendlyName != null) {
            request.addQueryParam("FriendlyName", this.friendlyName);
        }
        if (this.minutes != null) {
            request.addQueryParam("Minutes", this.minutes.toString());
        }
        if (this.startDate != null) {
            request.addQueryParam("StartDate", this.startDate.toString());
        }
        request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
    }
}

