/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.reader.api.v2010.account.sms;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.reader.Reader;
import com.twilio.sdk.resource.Page;
import com.twilio.sdk.resource.ResourceSet;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.api.v2010.account.sms.ShortCode;

public class ShortCodeReader
extends Reader<ShortCode> {
    private final String accountSid;
    private String friendlyName;
    private String shortCode;

    public ShortCodeReader(String accountSid) {
        this.accountSid = accountSid;
    }

    public ShortCodeReader byFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public ShortCodeReader byShortCode(String shortCode) {
        this.shortCode = shortCode;
        return this;
    }

    @Override
    public ResourceSet<ShortCode> execute(TwilioRestClient client) {
        return new ResourceSet<ShortCode>(this, client, this.firstPage());
    }

    @Override
    public Page<ShortCode> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, TwilioRestClient.Domains.API, "/2010-04-01/Accounts/" + this.accountSid + "/SMS/ShortCodes.json", client.getAccountSid());
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<ShortCode> nextPage(Page<ShortCode> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUri(), client.getAccountSid());
        return this.pageForRequest(client, request);
    }

    private Page<ShortCode> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("ShortCode read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Page.fromJson("short_codes", response.getContent(), ShortCode.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.friendlyName != null) {
            request.addQueryParam("FriendlyName", this.friendlyName);
        }
        if (this.shortCode != null) {
            request.addQueryParam("ShortCode", this.shortCode);
        }
        request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
    }
}

