/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.reader.api.v2010.account;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.reader.Reader;
import com.twilio.sdk.resource.Page;
import com.twilio.sdk.resource.ResourceSet;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.api.v2010.account.Call;
import com.twilio.sdk.type.PhoneNumber;

public class CallReader
extends Reader<Call> {
    private final String accountSid;
    private PhoneNumber to;
    private PhoneNumber from;
    private String parentCallSid;
    private Call.Status status;
    private String startTime;
    private String endTime;

    public CallReader(String accountSid) {
        this.accountSid = accountSid;
    }

    public CallReader byTo(PhoneNumber to) {
        this.to = to;
        return this;
    }

    public CallReader byFrom(PhoneNumber from) {
        this.from = from;
        return this;
    }

    public CallReader byParentCallSid(String parentCallSid) {
        this.parentCallSid = parentCallSid;
        return this;
    }

    public CallReader byStatus(Call.Status status) {
        this.status = status;
        return this;
    }

    public CallReader byStartTime(String startTime) {
        this.startTime = startTime;
        return this;
    }

    public CallReader byEndTime(String endTime) {
        this.endTime = endTime;
        return this;
    }

    @Override
    public ResourceSet<Call> execute(TwilioRestClient client) {
        return new ResourceSet<Call>(this, client, this.firstPage());
    }

    @Override
    public Page<Call> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, TwilioRestClient.Domains.API, "/2010-04-01/Accounts/" + this.accountSid + "/Calls.json", client.getAccountSid());
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Call> nextPage(Page<Call> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUri(), client.getAccountSid());
        return this.pageForRequest(client, request);
    }

    private Page<Call> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Call read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Page.fromJson("calls", response.getContent(), Call.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.to != null) {
            request.addQueryParam("To", this.to.toString());
        }
        if (this.from != null) {
            request.addQueryParam("From", this.from.toString());
        }
        if (this.parentCallSid != null) {
            request.addQueryParam("ParentCallSid", this.parentCallSid);
        }
        if (this.status != null) {
            request.addQueryParam("Status", this.status.toString());
        }
        if (this.startTime != null) {
            request.addQueryParam("StartTime", this.startTime);
        }
        if (this.endTime != null) {
            request.addQueryParam("EndTime", this.endTime);
        }
        request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
    }
}

