/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.reader.api.v2010.account;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.reader.Reader;
import com.twilio.sdk.resource.Page;
import com.twilio.sdk.resource.ResourceSet;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.api.v2010.account.Address;

public class AddressReader
extends Reader<Address> {
    private final String accountSid;
    private String customerName;
    private String friendlyName;
    private String isoCountry;

    public AddressReader(String accountSid) {
        this.accountSid = accountSid;
    }

    public AddressReader byCustomerName(String customerName) {
        this.customerName = customerName;
        return this;
    }

    public AddressReader byFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public AddressReader byIsoCountry(String isoCountry) {
        this.isoCountry = isoCountry;
        return this;
    }

    @Override
    public ResourceSet<Address> execute(TwilioRestClient client) {
        return new ResourceSet<Address>(this, client, this.firstPage());
    }

    @Override
    public Page<Address> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, TwilioRestClient.Domains.API, "/2010-04-01/Accounts/" + this.accountSid + "/Addresses.json", client.getAccountSid());
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Address> nextPage(Page<Address> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUri(), client.getAccountSid());
        return this.pageForRequest(client, request);
    }

    private Page<Address> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Address read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Page.fromJson("addresses", response.getContent(), Address.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.customerName != null) {
            request.addQueryParam("CustomerName", this.customerName);
        }
        if (this.friendlyName != null) {
            request.addQueryParam("FriendlyName", this.friendlyName);
        }
        if (this.isoCountry != null) {
            request.addQueryParam("IsoCountry", this.isoCountry);
        }
        request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
    }
}

