/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.http;

import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Scanner;

public class Response {
    private final InputStream stream;
    private final String content;
    private final int statusCode;

    public Response(String content, int statusCode) {
        this.stream = null;
        this.content = content;
        this.statusCode = statusCode;
    }

    public Response(InputStream stream, int statusCode) {
        this.stream = stream;
        this.content = null;
        this.statusCode = statusCode;
    }

    public String getContent() {
        if (this.content != null) {
            return this.content;
        }
        try {
            if (this.stream.available() == 0) {
                return "";
            }
        }
        catch (IOException e) {
            throw new ApiConnectionException("IOException during API request to Twilio", e);
        }
        Scanner scanner = new Scanner(this.stream, "UTF-8").useDelimiter("\\A");
        String data = scanner.next();
        scanner.close();
        return data;
    }

    public InputStream getStream() {
        if (this.stream != null) {
            return this.stream;
        }
        try {
            return new ByteArrayInputStream(this.content.getBytes("utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new ApiException("UTF-8 encoding not supported", e);
        }
    }

    public int getStatusCode() {
        return this.statusCode;
    }
}

