/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.fetcher.trunking.v1.trunk;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.fetcher.Fetcher;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.trunking.v1.trunk.CredentialList;

public class CredentialListFetcher
extends Fetcher<CredentialList> {
    private final String trunkSid;
    private final String sid;

    public CredentialListFetcher(String trunkSid, String sid) {
        this.trunkSid = trunkSid;
        this.sid = sid;
    }

    @Override
    public CredentialList execute(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, TwilioRestClient.Domains.TRUNKING, "/v1/Trunks/" + this.trunkSid + "/CredentialLists/" + this.sid + "", client.getAccountSid());
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("CredentialList fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return CredentialList.fromJson(response.getStream(), client.getObjectMapper());
    }
}

