/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.fetcher.preview.wireless.device;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.fetcher.Fetcher;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.preview.wireless.device.Usage;

public class UsageFetcher
extends Fetcher<Usage> {
    private final String deviceSid;
    private String end;
    private String start;

    public UsageFetcher(String deviceSid) {
        this.deviceSid = deviceSid;
    }

    public UsageFetcher setEnd(String end) {
        this.end = end;
        return this;
    }

    public UsageFetcher setStart(String start) {
        this.start = start;
        return this;
    }

    @Override
    public Usage execute(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, TwilioRestClient.Domains.PREVIEW, "/wireless/Devices/" + this.deviceSid + "/Usage", client.getAccountSid());
        this.addQueryParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Usage fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Usage.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.end != null) {
            request.addQueryParam("End", this.end);
        }
        if (this.start != null) {
            request.addQueryParam("Start", this.start);
        }
    }
}

