/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.fetcher.lookups.v1;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.converter.PrefixedCollapsibleMap;
import com.twilio.sdk.converter.Promoter;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.fetcher.Fetcher;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.lookups.v1.PhoneNumber;
import java.util.List;
import java.util.Map;

public class PhoneNumberFetcher
extends Fetcher<PhoneNumber> {
    private final com.twilio.sdk.type.PhoneNumber phoneNumber;
    private String countryCode;
    private String type;
    private List<String> addOns;
    private Map<String, Object> addOnsData;

    public PhoneNumberFetcher(com.twilio.sdk.type.PhoneNumber phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public PhoneNumberFetcher setCountryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    public PhoneNumberFetcher setType(String type) {
        this.type = type;
        return this;
    }

    public PhoneNumberFetcher setAddOns(List<String> addOns) {
        this.addOns = addOns;
        return this;
    }

    public PhoneNumberFetcher setAddOns(String addOns) {
        return this.setAddOns(Promoter.listOfOne(addOns));
    }

    public PhoneNumberFetcher setAddOnsData(Map<String, Object> addOnsData) {
        this.addOnsData = addOnsData;
        return this;
    }

    @Override
    public PhoneNumber execute(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, TwilioRestClient.Domains.LOOKUPS, "/v1/PhoneNumbers/" + this.phoneNumber + "", client.getAccountSid());
        this.addQueryParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("PhoneNumber fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return PhoneNumber.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.countryCode != null) {
            request.addQueryParam("CountryCode", this.countryCode);
        }
        if (this.type != null) {
            request.addQueryParam("Type", this.type);
        }
        if (this.addOns != null) {
            for (String prop : this.addOns) {
                request.addQueryParam("AddOns", prop.toString());
            }
        }
        if (this.addOnsData != null) {
            Map<String, String> params = PrefixedCollapsibleMap.serialize(this.addOnsData, "AddOns");
            for (Map.Entry<String, String> entry : params.entrySet()) {
                request.addQueryParam(entry.getKey(), entry.getValue());
            }
        }
    }
}

