/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.fetcher.ipmessaging.v1.service;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.fetcher.Fetcher;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.ipmessaging.v1.service.User;

public class UserFetcher
extends Fetcher<User> {
    private final String serviceSid;
    private final String sid;

    public UserFetcher(String serviceSid, String sid) {
        this.serviceSid = serviceSid;
        this.sid = sid;
    }

    @Override
    public User execute(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, TwilioRestClient.Domains.IPMESSAGING, "/v1/Services/" + this.serviceSid + "/Users/" + this.sid + "", client.getAccountSid());
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("User fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return User.fromJson(response.getStream(), client.getObjectMapper());
    }
}

