/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.deleter.trunking.v1;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.deleter.Deleter;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.trunking.v1.Trunk;

public class TrunkDeleter
extends Deleter<Trunk> {
    private final String sid;

    public TrunkDeleter(String sid) {
        this.sid = sid;
    }

    @Override
    public boolean execute(TwilioRestClient client) {
        Request request = new Request(HttpMethod.DELETE, TwilioRestClient.Domains.TRUNKING, "/v1/Trunks/" + this.sid + "", client.getAccountSid());
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Trunk delete failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return response.getStatusCode() == 204;
    }
}

