/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.creator.api.v2010.account.sip.domain;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.creator.Creator;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.api.v2010.account.sip.domain.IpAccessControlListMapping;

public class IpAccessControlListMappingCreator
extends Creator<IpAccessControlListMapping> {
    private final String accountSid;
    private final String domainSid;
    private final String ipAccessControlListSid;

    public IpAccessControlListMappingCreator(String accountSid, String domainSid, String ipAccessControlListSid) {
        this.accountSid = accountSid;
        this.domainSid = domainSid;
        this.ipAccessControlListSid = ipAccessControlListSid;
    }

    @Override
    public IpAccessControlListMapping execute(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, TwilioRestClient.Domains.API, "/2010-04-01/Accounts/" + this.accountSid + "/SIP/Domains/" + this.domainSid + "/IpAccessControlListMappings.json", client.getAccountSid());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("IpAccessControlListMapping creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return IpAccessControlListMapping.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.ipAccessControlListSid != null) {
            request.addPostParam("IpAccessControlListSid", this.ipAccessControlListSid);
        }
    }
}

