/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Predicate;
import com.twilio.sdk.http.HttpClient;
import com.twilio.sdk.http.NetworkHttpClient;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;

public class TwilioRestClient {
    public static final int HTTP_STATUS_CODE_CREATED = 201;
    public static final int HTTP_STATUS_CODE_NO_CONTENT = 204;
    public static final int HTTP_STATUS_CODE_OK = 200;
    public static final Predicate<Integer> SUCCESS = new Predicate<Integer>(){

        public boolean apply(Integer i) {
            return i != null && i >= 200 && i < 300;
        }
    };
    private HttpClient httpClient;
    private final ObjectMapper objectMapper;
    private final String username;
    private final String password;
    private final String accountSid;

    public TwilioRestClient(String username, String password) {
        this(username, password, username, new NetworkHttpClient());
    }

    public TwilioRestClient(String username, String password, String accountSid) {
        this(username, password, accountSid, new NetworkHttpClient());
    }

    public TwilioRestClient(String username, String password, String accountSid, HttpClient httpClient) {
        this.username = username;
        this.password = password;
        this.accountSid = accountSid;
        this.httpClient = httpClient;
        this.objectMapper = new ObjectMapper();
    }

    public Response request(Request request) {
        request.setAuth(this.username, this.password);
        return this.httpClient.reliableRequest(request);
    }

    public String getAccountSid() {
        return this.accountSid;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public static enum Domains {
        API("api"),
        CONVERSATIONS("conversations"),
        LOOKUPS("lookups"),
        MONITOR("monitor"),
        PRICING("pricing"),
        TASKROUTER("taskrouter"),
        TRUNKING("trunking"),
        IPMESSAGING("ip-messaging"),
        NOTIFICATIONS("notifications"),
        PREVIEW("preview");

        private final String domain;

        private Domains(String domain) {
            this.domain = domain;
        }

        public String toString() {
            return this.domain;
        }
    }
}

