/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.list.taskrouter;

import com.twilio.sdk.TwilioRestException;
import com.twilio.sdk.TwilioRestResponse;
import com.twilio.sdk.TwilioTaskRouterClient;
import com.twilio.sdk.resource.NextGenListResource;
import com.twilio.sdk.resource.factory.Factory;
import com.twilio.sdk.resource.instance.taskrouter.Task;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.NameValuePair;
import org.json.simple.JSONObject;

public class TaskList
extends NextGenListResource<Task, TwilioTaskRouterClient>
implements Factory<Task> {
    private String workspaceSid;

    public TaskList(TwilioTaskRouterClient client, String workspaceSid) {
        super(client);
        this.workspaceSid = workspaceSid;
    }

    public TaskList(TwilioTaskRouterClient client, String workspaceSid, Map<String, String> filters) {
        super(client, filters);
        this.workspaceSid = workspaceSid;
    }

    @Override
    public Task create(Map<String, String> params) throws TwilioRestException {
        TwilioRestResponse response = ((TwilioTaskRouterClient)this.getClient()).safeRequest(this.getResourceLocation(), "POST", params);
        return this.makeNew((TwilioTaskRouterClient)this.getClient(), response.toMap());
    }

    @Override
    public Task create(List<NameValuePair> params) throws TwilioRestException {
        TwilioRestResponse response = ((TwilioTaskRouterClient)this.getClient()).safeRequest(this.getResourceLocation(), "POST", params);
        return this.makeNew((TwilioTaskRouterClient)this.getClient(), response.toMap());
    }

    public Task create(String workflowSid, Map<String, String> attributes, Integer priority, Integer timeout) throws TwilioRestException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("WorkflowSid", workflowSid);
        if (attributes != null) {
            params.put("Attributes", JSONObject.toJSONString(attributes));
        } else {
            params.put("Attributes", "{}");
        }
        if (priority != null) {
            params.put("Priority", priority.toString());
        }
        if (timeout != null) {
            params.put("Timeout", timeout.toString());
        }
        TwilioRestResponse response = ((TwilioTaskRouterClient)this.getClient()).safeRequest(this.getResourceLocation(), "POST", params);
        return this.makeNew((TwilioTaskRouterClient)this.getClient(), response.toMap());
    }

    @Override
    protected Task makeNew(TwilioTaskRouterClient client, Map<String, Object> params) {
        return new Task(client, params);
    }

    @Override
    protected String getResourceLocation() {
        return "/v1/Workspaces/" + this.workspaceSid + "/Tasks";
    }
}

