/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.list.ipmessaging;

import com.twilio.sdk.TwilioIPMessagingClient;
import com.twilio.sdk.TwilioRestException;
import com.twilio.sdk.TwilioRestResponse;
import com.twilio.sdk.resource.NextGenListResource;
import com.twilio.sdk.resource.factory.ResourceFactory;
import com.twilio.sdk.resource.instance.ipmessaging.Role;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;

public class RoleList
extends NextGenListResource<Role, TwilioIPMessagingClient>
implements ResourceFactory<Role> {
    private final String serviceSid;

    public RoleList(TwilioIPMessagingClient client, String serviceSid) {
        this(client, serviceSid, null);
    }

    public RoleList(TwilioIPMessagingClient client, String serviceSid, Map<String, String> filters) {
        super(client, filters);
        if (StringUtils.isEmpty((CharSequence)serviceSid)) {
            throw new IllegalArgumentException("serviceSid cannot be null");
        }
        this.serviceSid = serviceSid;
    }

    @Override
    protected Role makeNew(TwilioIPMessagingClient client, Map<String, Object> params) {
        return new Role(client, params);
    }

    @Override
    protected String getResourceLocation() {
        return "/v1/Services/" + this.serviceSid + "/Roles";
    }

    @Override
    public Role create(Map<String, String> params) throws TwilioRestException {
        TwilioRestResponse response = ((TwilioIPMessagingClient)this.getClient()).safeRequest(this.getResourceLocation(), "POST", params);
        return this.makeNew((TwilioIPMessagingClient)this.getClient(), response.toMap());
    }

    @Override
    public Role create(List<NameValuePair> params) throws TwilioRestException {
        TwilioRestResponse response = ((TwilioIPMessagingClient)this.getClient()).safeRequest(this.getResourceLocation(), "POST", params);
        return this.makeNew((TwilioIPMessagingClient)this.getClient(), response.toMap());
    }
}

