/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.list;

import com.twilio.sdk.TwilioRestClient;
import com.twilio.sdk.resource.ListResource;
import com.twilio.sdk.resource.instance.UsageRecord;
import java.util.Map;

public class UsageRecordList
extends ListResource<UsageRecord, TwilioRestClient> {
    private final Type type;

    public UsageRecordList(TwilioRestClient client) {
        this(client, (Type)null);
    }

    public UsageRecordList(TwilioRestClient client, Type type) {
        super(client);
        this.type = type;
    }

    public UsageRecordList(TwilioRestClient client, Map<String, String> filters) {
        this(client, filters, null);
    }

    public UsageRecordList(TwilioRestClient client, Map<String, String> filters, Type type) {
        super(client, filters);
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    @Override
    protected String getResourceLocation() {
        if (this.type == null) {
            return "/2010-04-01/Accounts/" + this.getRequestAccountSid() + "/Usage/Records";
        }
        return "/2010-04-01/Accounts/" + this.getRequestAccountSid() + "/Usage/Records/" + this.type.getValue();
    }

    @Override
    protected UsageRecord makeNew(TwilioRestClient client, Map<String, Object> properties) {
        return new UsageRecord(client, properties);
    }

    @Override
    protected String getListKey() {
        return "UsageRecords";
    }

    public static enum Type {
        ALL_TIME("AllTime"),
        DAILY("Daily"),
        LAST_MONTH("LastMonth"),
        MONTHLY("Monthly"),
        THIS_MONTH("ThisMonth"),
        TODAY("Today"),
        YEARLY("Yearly"),
        YESTERDAY("Yesterday");

        private final String value;

        private Type(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

